/*
 * Decompiled with CFR 0.152.
 */
package jpack.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import jpack.util.StdLib;

public class AdvByteArrayInputStream
extends ByteArrayInputStream {
    public AdvByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    public int getPos() {
        return this.pos;
    }

    public int getLeftSize() {
        return this.buf.length - this.pos;
    }

    public String readString(int len) throws IOException {
        byte[] axBuf = new byte[len];
        int iLen = this.read(axBuf);
        if (iLen != len) {
            throw new IOException("readString Length error, Out of buffer.");
        }
        return new String(axBuf);
    }

    public int readInt() throws IOException {
        byte[] axBuf = new byte[4];
        int iLen = this.read(axBuf);
        if (iLen != 4) {
            throw new IOException("readInt error, Out of buffer.");
        }
        return StdLib.byteToInt(axBuf, 0);
    }

    public byte readByte() throws IOException {
        int iLen = this.read();
        if (iLen == -1) {
            throw new IOException("readByte error, Out of buffer.");
        }
        return (byte)iLen;
    }

    public int readUnsignByte() throws IOException {
        byte[] buf = new byte[1];
        int iLen = this.read(buf);
        if (iLen == -1) {
            throw new IOException("readUnsignByte error, Out of buffer.");
        }
        iLen = StdLib.unsignByte(buf[0]);
        return iLen;
    }

    public byte[] readBytes(int len) throws IOException {
        int iLen;
        byte[] result = null;
        if (len != 0 && (iLen = this.read(result = new byte[len])) != len) {
            throw new IOException("readBytes error, Out of buffer.");
        }
        return result;
    }
}

