/*
 * Decompiled with CFR 0.152.
 */
package jpack.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpack.util.CharacterDecoder;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;

public class BASE64Decoder
extends CharacterDecoder {
    public static int pad = 61;
    public static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];
    byte[] decode_buffer = new byte[4];

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        return 72000;
    }

    protected void decodeAtom(InputStream inputstream, OutputStream outputstream, int i) throws IOException {
        int j;
        int byte0 = -1;
        int byte1 = -1;
        int byte2 = -1;
        int byte3 = -1;
        if (i < 2) {
            throw new CEFormatException("BASE64Decoder: Not enough bytes for an atom.");
        }
        do {
            if ((j = inputstream.read()) != -1) continue;
            throw new CEStreamExhausted();
        } while (j == 10 || j == 13);
        this.decode_buffer[0] = (byte)j;
        j = this.readFully(inputstream, this.decode_buffer, 1, i - 1);
        if (j == -1) {
            throw new CEStreamExhausted();
        }
        if (i > 3 && this.decode_buffer[3] == pad) {
            i = 3;
        }
        if (i > 2 && this.decode_buffer[2] == pad) {
            i = 2;
        }
        switch (i) {
            case 4: {
                byte3 = pem_convert_array[this.decode_buffer[3] & 0xFF];
            }
            case 3: {
                byte2 = pem_convert_array[this.decode_buffer[2] & 0xFF];
            }
            case 2: {
                byte1 = pem_convert_array[this.decode_buffer[1] & 0xFF];
                byte0 = pem_convert_array[this.decode_buffer[0] & 0xFF];
            }
        }
        switch (i) {
            case 2: {
                outputstream.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                break;
            }
            case 3: {
                outputstream.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                outputstream.write((byte)(byte1 << 4 & 0xF0 | byte2 >>> 2 & 0xF));
                break;
            }
            case 4: {
                outputstream.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                outputstream.write((byte)(byte1 << 4 & 0xF0 | byte2 >>> 2 & 0xF));
                outputstream.write((byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F));
            }
        }
    }

    static {
        for (int i = 0; i < 255; ++i) {
            BASE64Decoder.pem_convert_array[i] = -1;
        }
        for (int j = 0; j < pem_array.length; ++j) {
            BASE64Decoder.pem_convert_array[BASE64Decoder.pem_array[j]] = (byte)j;
        }
    }
}

