/*
 * Decompiled with CFR 0.152.
 */
package xdesign;

import jpack.util.Base64X;
import xdesign.XAgentBase;
import xdesign.XCLib;
import xdesign.XCPack_3_6_1;
import xdesign.XCUnPack_3_6_1;
import xdesign.XChannelAgent;
import xdesign.XException;
import xdesign.XPwdAuthen;

public final class XTicketAuthen {
    public String defAuthenID = "";
    public String defAuthenPwd = "";
    public XAgentBase xAgent;
    private XCUnPack_3_6_1 _$190;

    protected void checkXAgent() throws XException {
        if (this.xAgent == null) {
            throw new XException(215);
        }
    }

    protected byte[] getPwdPacket(String authenID, String authenPwd) throws XException {
        this.checkXAgent();
        this.xAgent.checkTime();
        XPwdAuthen xPwd = new XPwdAuthen();
        xPwd.xAgent = this.xAgent;
        if (authenID != null && authenID != "") {
            return xPwd.getVerifyPacket(authenID, authenPwd);
        }
        if (this.defAuthenID != null && this.defAuthenID != "") {
            return xPwd.getVerifyPacket(this.defAuthenID, this.defAuthenPwd);
        }
        return null;
    }

    protected byte[] getNewUserTicket(int ticketType, int validDuration, int idleTimeout, byte[] authenPacket) throws XException {
        return XCPack_3_6_1.getPacket(this.xAgent.packetType, 1, this.xAgent.getCheckPacket(), (byte)ticketType, validDuration, idleTimeout, null, authenPacket);
    }

    protected int executeNewUserTicket(int ticketType, int validDuration, int idleTimeout, byte[] authenPacket) throws XException {
        this._$190 = (XCUnPack_3_6_1)((XChannelAgent)this.xAgent).getCUnPack(this.getNewUserTicket(ticketType, validDuration, idleTimeout, authenPacket));
        return this._$190.resultCode;
    }

    public void setDefaultAuthenPwd(String defAuthenID, String defAuthenPwd) {
        this.defAuthenID = defAuthenID;
        this.defAuthenPwd = defAuthenPwd;
    }

    public int getTicketByPacket(int ticketType, int validDuration, int idleTimeout, String authenPacket) {
        try {
            this.checkXAgent();
            int n = this.executeNewUserTicket(ticketType, validDuration, idleTimeout, Base64X.decode(authenPacket));
            return n;
        }
        catch (XException xe) {
            int n = xe.getErrorCode();
            return n;
        }
    }

    public int getTicketByPwd(int ticketType, int validDuration, int idleTimeout, String authenID, String authenPwd) {
        try {
            int n = this.executeNewUserTicket(ticketType, validDuration, idleTimeout, this.getPwdPacket(authenID, authenPwd));
            return n;
        }
        catch (XException xe) {
            int n = xe.getErrorCode();
            return n;
        }
    }

    public int getTicketByResult(String resultPacket) {
        try {
            this._$190 = (XCUnPack_3_6_1)XCLib.doCUnPack(Base64X.decode(resultPacket));
            if (this._$190.version != 3 || this._$190.svcType != 6 || this._$190.svcCode != 1) {
                this._$190.resultCode = 8;
                int n = 8;
                return n;
            }
            int n = this._$190.resultCode;
            return n;
        }
        catch (XException xe) {
            int n = xe.getErrorCode();
            return n;
        }
        catch (Exception e) {
            int n = 8;
            return n;
        }
    }

    public String getTicketInResult() {
        if (this._$190 != null && this._$190.resultCode == 0 && this._$190.version == 3 && this._$190.svcType == 6 && this._$190.svcCode == 1 && this._$190.data.newTicketID.length() > 0) {
            return this._$190.data.newTicketID;
        }
        return "";
    }

    public String verifyExport(String authenTicket) {
        try {
            this.checkXAgent();
            String string = Base64X.encode(XCPack_3_6_1.getPacket(this.xAgent.packetType, 3, this.xAgent.getCheckPacket(), (byte)0, 0, 0, authenTicket, null));
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
    }
}

