/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import org.jdesktop.animation.transitions.Effect;

public final class EffectsManager {
    private static final Map<JComponent, Effect> cachedChangingEffects = new HashMap<JComponent, Effect>();
    private static final Map<JComponent, Effect> cachedAppearingEffects = new HashMap<JComponent, Effect>();
    private static final Map<JComponent, Effect> cachedDisappearingEffects = new HashMap<JComponent, Effect>();

    public static void setEffect(JComponent component, Effect effect, TransitionType transitionType) {
        if (effect == null) {
            EffectsManager.removeEffect(component, transitionType);
            return;
        }
        switch (1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[transitionType.ordinal()]) {
            case 1: {
                cachedChangingEffects.put(component, effect);
                break;
            }
            case 2: {
                cachedAppearingEffects.put(component, effect);
                break;
            }
            case 3: {
                cachedDisappearingEffects.put(component, effect);
                break;
            }
            default: {
                throw new InternalError("unknown TransitionType");
            }
        }
    }

    public static Effect getEffect(JComponent component, TransitionType transitionType) {
        switch (1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[transitionType.ordinal()]) {
            case 1: {
                return cachedChangingEffects.get(component);
            }
            case 2: {
                return cachedAppearingEffects.get(component);
            }
            case 3: {
                return cachedDisappearingEffects.get(component);
            }
        }
        throw new InternalError("unknown TransitionType");
    }

    public static void removeEffect(JComponent component, TransitionType transitionType) {
        switch (1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[transitionType.ordinal()]) {
            case 1: {
                cachedChangingEffects.remove(component);
            }
            case 2: {
                cachedAppearingEffects.remove(component);
            }
            case 3: {
                cachedDisappearingEffects.remove(component);
            }
        }
        throw new InternalError("unknown TransitionType");
    }

    public static void clearEffects(TransitionType transitionType) {
        switch (1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[transitionType.ordinal()]) {
            case 1: {
                cachedChangingEffects.clear();
            }
            case 2: {
                cachedAppearingEffects.clear();
            }
            case 3: {
                cachedDisappearingEffects.clear();
            }
        }
        throw new InternalError("unknown TransitionType");
    }

    public static void clearAllEffects() {
        cachedChangingEffects.clear();
        cachedAppearingEffects.clear();
        cachedDisappearingEffects.clear();
    }

    private EffectsManager() {
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType;

        static {
            $SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType = new int[TransitionType.values().length];
            try {
                1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[TransitionType.CHANGING.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[TransitionType.APPEARING.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jdesktop$animation$transitions$EffectsManager$TransitionType[TransitionType.DISAPPEARING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransitionType
    extends Enum_<TransitionType> {
        public static final TransitionType CHANGING = new TransitionType("CHANGING", 0);
        public static final TransitionType APPEARING = new TransitionType("APPEARING", 1);
        public static final TransitionType DISAPPEARING = new TransitionType("DISAPPEARING", 2);
        private static final /* synthetic */ TransitionType[] $VALUES;
        static /* synthetic */ Class class$org$jdesktop$animation$transitions$EffectsManager$TransitionType;

        public static final TransitionType[] values() {
            return (TransitionType[])$VALUES.clone();
        }

        public static TransitionType valueOf(String name) {
            Class<?> clazz = class$org$jdesktop$animation$transitions$EffectsManager$TransitionType;
            if (clazz == null) {
                clazz = class$org$jdesktop$animation$transitions$EffectsManager$TransitionType = new TransitionType[0].getClass().getComponentType();
            }
            return (TransitionType)Enum_.valueOf((Class)clazz, (String)name);
        }

        private TransitionType() {
            super((String)var1_1, n);
        }

        static {
            $VALUES = new TransitionType[]{CHANGING, APPEARING, DISAPPEARING};
        }
    }
}

