/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions.effects;

import java.awt.Graphics2D;
import javax.swing.JComponent;
import net.sf.retrotranslator.runtime.java.lang._Double;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.jdesktop.animation.transitions.ComponentState;
import org.jdesktop.animation.transitions.Effect;

public class Rotate
extends Effect {
    private final int xCenter;
    private final int yCenter;
    private final double endRadians;
    private double radians;
    private PropertySetter ps;

    public void setRadians(double radians) {
        this.radians = radians;
    }

    public Rotate(int degrees, JComponent component) {
        this(degrees, component.getWidth() / 2, component.getHeight() / 2);
    }

    public Rotate(int degrees, int xCenter, int yCenter) {
        this.endRadians = Math.toRadians(degrees);
        this.xCenter = xCenter;
        this.yCenter = yCenter;
    }

    public Rotate(ComponentState start, ComponentState end, int degrees, int xCenter, int yCenter) {
        this(degrees, xCenter, yCenter);
        this.setComponentStates(start, end);
    }

    public void init(Animator animator, Effect parentEffect) {
        this.ps = new PropertySetter((Object)this, "radians", (Object[])new Double[]{_Double.valueOf((double)0.0), _Double.valueOf((double)this.endRadians)});
        animator.addTarget((TimingTarget)this.ps);
        super.init(animator, null);
    }

    public void cleanup(Animator animator) {
        animator.removeTarget((TimingTarget)this.ps);
    }

    public void setup(Graphics2D g2d) {
        g2d.translate(this.xCenter, this.yCenter);
        g2d.rotate(this.radians);
        g2d.translate(-this.xCenter, -this.yCenter);
        super.setup(g2d);
    }
}

