/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil {
    public static Map<String, Object> Dom2Map(String str) throws DocumentException {
        Document documents = DocumentHelper.parseText((String)str);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (documents == null) {
            return map;
        }
        Element root = documents.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), XmlUtil.Dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Map<String, Object> Dom2MapV2(String str) throws DocumentException {
        Document documents = DocumentHelper.parseText((String)str);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (documents == null) {
            return map;
        }
        Element root = documents.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                ArrayList<Map<String, Object>> mapList = (ArrayList<Map<String, Object>>)map.get(e.getName());
                if (null == mapList) {
                    mapList = new ArrayList<Map<String, Object>>();
                }
                Map<String, Object> objectMap = XmlUtil.Dom2MapV2(e);
                mapList.add(objectMap);
                map.put(e.getName(), mapList);
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map<String, Object> Dom2MapV2(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Object> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map<String, Object> m = XmlUtil.Dom2MapV2(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map<String, Object> Dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Object> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map<String, Object> m = XmlUtil.Dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Document createDocument(String rootName) {
        Element root = DocumentHelper.createElement((String)rootName);
        root.addNamespace("ofd", "http://www.ofdspec.org");
        return DocumentHelper.createDocument((Element)root);
    }

    public static Document createOfdDocument(String rootName) {
        Element root = DocumentHelper.createElement((String)rootName);
        return DocumentHelper.createDocument((Element)root);
    }

    public static Element AddNode(Element parentNode, String nodeName, String nodeText) {
        Element element = parentNode.addElement(nodeName);
        if (nodeText != null) {
            element.setText(nodeText);
        }
        return element;
    }

    public static Document loadXML(String xml) throws Exception {
        Document document = DocumentHelper.parseText((String)xml);
        return document;
    }

    public static Document loadXML(byte[] xmlData) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlData);
        Document document = reader.read((InputStream)bis);
        return document;
    }

    public static Document loadFromFile(String fileName) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(fileName));
        return document;
    }

    public static void saveToFile(Document document, String strPath) throws IOException {
        OutputFormat format = new OutputFormat("  ", true);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(strPath), format);
        xmlWriter.write(document);
        xmlWriter.close();
    }

    public static byte[] toByteArray(Document document) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLWriter xmlWriter = new XMLWriter((OutputStream)bos);
        xmlWriter.write(document);
        xmlWriter.close();
        byte[] bts = bos.toByteArray();
        bos.close();
        return bts;
    }

    public static Map<String, Object> Dom2AllElectricInvoiceMap(byte[] invoiceByte) throws Exception {
        Document document = XmlUtil.loadXML(invoiceByte);
        Element root = document.getRootElement();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        Iterator iteBook = root.elementIterator();
        while (iteBook.hasNext()) {
            Element bookEle = (Element)iteBook.next();
            Iterator subBookEle = bookEle.elementIterator();
            while (subBookEle.hasNext()) {
                Element subEle = (Element)subBookEle.next();
                String nodeName = subEle.getName();
                if (!"DocInfo".equals(nodeName)) continue;
                Iterator docInfoEle = subEle.elementIterator();
                while (docInfoEle.hasNext()) {
                    Element t = (Element)docInfoEle.next();
                    String tName = t.getName();
                    if (!"CustomDatas".equals(tName)) continue;
                    Iterator customDataEle = t.elementIterator();
                    while (customDataEle.hasNext()) {
                        Element customData = (Element)customDataEle.next();
                        Attribute name = customData.attribute("Name");
                        if (name == null) continue;
                        String value = name.getValue();
                        if ("\u53d1\u7968\u53f7\u7801".equals(value)) {
                            map.put("invoiceNo", customData.getText());
                            continue;
                        }
                        if ("\u5408\u8ba1\u7a0e\u989d".equals(value)) {
                            map.put("totalTaxAmount", customData.getText());
                            continue;
                        }
                        if ("\u5408\u8ba1\u91d1\u989d".equals(value)) {
                            map.put("invoiceAmount", customData.getText());
                            continue;
                        }
                        if ("\u5f00\u7968\u65e5\u671f".equals(value)) {
                            map.put("invoiceDate", customData.getText());
                            continue;
                        }
                        if ("\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7".equals(value)) {
                            map.put("buyerTaxNo", customData.getText());
                            continue;
                        }
                        if (!"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7".equals(value)) continue;
                        map.put("salerTaxNo", customData.getText());
                    }
                }
            }
        }
        return map;
    }
}

