/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.ofd;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectUtil {
    private static final Map<Class<?>, List<Field>> FIELDS_CACHE = new HashMap();

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        List<Field> fields = ReflectUtil.getFields(beanClass);
        for (Field field : fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static List<Field> getFields(Class<?> beanClass) throws SecurityException {
        List<Field> allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields && !allFields.isEmpty()) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        FIELDS_CACHE.put(beanClass, allFields);
        return allFields;
    }

    public static List<Field> getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        ArrayList<Field> allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            if (null == allFields) {
                allFields = new ArrayList<Field>();
            }
            allFields.addAll(Arrays.asList(declaredFields));
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

