/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1;

import com.apusic.org.bouncycastle.asn1.ASN1Encodable;
import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1OutputStream;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Set;
import com.apusic.org.bouncycastle.asn1.StreamUtil;
import java.io.IOException;

public class DLSet
extends ASN1Set {
    private int bodyLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1Encodable element) {
        super(element);
    }

    public DLSet(ASN1EncodableVector elementVector) {
        super(elementVector, false);
    }

    public DLSet(ASN1Encodable[] elements) {
        super(elements, false);
    }

    DLSet(boolean isSorted, ASN1Encodable[] elements) {
        super(isSorted, elements);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int count = this.elements.length;
            int totalLength = 0;
            for (int i = 0; i < count; ++i) {
                ASN1Primitive dlObject = this.elements[i].toASN1Primitive().toDLObject();
                totalLength += dlObject.encodedLength();
            }
            this.bodyLength = totalLength;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (withTag) {
            out.write(49);
        }
        ASN1OutputStream dlOut = out.getDLSubStream();
        int count = this.elements.length;
        if (this.bodyLength >= 0 || count > 16) {
            out.writeLength(this.getBodyLength());
            for (int i = 0; i < count; ++i) {
                dlOut.writePrimitive(this.elements[i].toASN1Primitive(), true);
            }
        } else {
            int i;
            int totalLength = 0;
            ASN1Primitive[] dlObjects = new ASN1Primitive[count];
            for (i = 0; i < count; ++i) {
                ASN1Primitive dlObject;
                dlObjects[i] = dlObject = this.elements[i].toASN1Primitive().toDLObject();
                totalLength += dlObject.encodedLength();
            }
            this.bodyLength = totalLength;
            out.writeLength(totalLength);
            for (i = 0; i < count; ++i) {
                dlOut.writePrimitive(dlObjects[i], true);
            }
        }
    }

    ASN1Primitive toDLObject() {
        return this;
    }
}

