/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.bc;

import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1OctetString;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.DEROctetString;
import com.apusic.org.bouncycastle.asn1.DERSequence;
import com.apusic.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.apusic.org.bouncycastle.util.Arrays;

public class EncryptedSecretKeyData
extends ASN1Object {
    private final AlgorithmIdentifier keyEncryptionAlgorithm;
    private final ASN1OctetString encryptedKeyData;

    public EncryptedSecretKeyData(AlgorithmIdentifier keyEncryptionAlgorithm, byte[] encryptedKeyData) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.encryptedKeyData = new DEROctetString(Arrays.clone(encryptedKeyData));
    }

    private EncryptedSecretKeyData(ASN1Sequence seq) {
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.encryptedKeyData = ASN1OctetString.getInstance(seq.getObjectAt(1));
    }

    public static EncryptedSecretKeyData getInstance(Object o) {
        if (o instanceof EncryptedSecretKeyData) {
            return (EncryptedSecretKeyData)o;
        }
        if (o != null) {
            return new EncryptedSecretKeyData(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public byte[] getEncryptedKeyData() {
        return Arrays.clone(this.encryptedKeyData.getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.keyEncryptionAlgorithm);
        v.add(this.encryptedKeyData);
        return new DERSequence(v);
    }
}

