/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.cms;

import com.apusic.org.bouncycastle.asn1.ASN1Encodable;
import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.ASN1TaggedObject;
import com.apusic.org.bouncycastle.asn1.BERSequence;
import com.apusic.org.bouncycastle.asn1.BERTaggedObject;
import com.apusic.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class ContentInfo
extends ASN1Object
implements CMSObjectIdentifiers {
    private ASN1ObjectIdentifier contentType;
    private ASN1Encodable content;

    public static ContentInfo getInstance(Object obj) {
        if (obj instanceof ContentInfo) {
            return (ContentInfo)obj;
        }
        if (obj != null) {
            return new ContentInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static ContentInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ContentInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public ContentInfo(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            ASN1TaggedObject tagged = (ASN1TaggedObject)seq.getObjectAt(1);
            if (!tagged.isExplicit() || tagged.getTagNo() != 0) {
                throw new IllegalArgumentException("Bad tag for 'content'");
            }
            this.content = tagged.getObject();
        }
    }

    public ContentInfo(ASN1ObjectIdentifier contentType, ASN1Encodable content) {
        this.contentType = contentType;
        this.content = content;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.contentType);
        if (this.content != null) {
            v.add(new BERTaggedObject(0, this.content));
        }
        return new BERSequence(v);
    }
}

