/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.its;

import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1Integer;
import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.DERSequence;
import com.apusic.org.bouncycastle.asn1.its.Ieee1609Dot2Content;
import java.math.BigInteger;

public class Ieee1609Dot2Data
extends ASN1Object {
    private final BigInteger protcolVersion;
    private final Ieee1609Dot2Content content;

    private Ieee1609Dot2Data(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("sequence not length 2");
        }
        this.protcolVersion = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        this.content = Ieee1609Dot2Content.getInstance(seq.getObjectAt(1));
    }

    public static Ieee1609Dot2Data getInstance(Object src) {
        if (src instanceof Ieee1609Dot2Data) {
            return (Ieee1609Dot2Data)src;
        }
        if (src != null) {
            return new Ieee1609Dot2Data(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        return new DERSequence(v);
    }
}

