/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.asn1.its;

import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1Object;
import com.apusic.org.bouncycastle.asn1.ASN1Primitive;
import com.apusic.org.bouncycastle.asn1.ASN1Sequence;
import com.apusic.org.bouncycastle.asn1.DERSequence;
import com.apusic.org.bouncycastle.asn1.its.GroupLinkageValue;
import com.apusic.org.bouncycastle.asn1.its.IValue;
import com.apusic.org.bouncycastle.asn1.its.LinkageValue;

public class LinkageData
extends ASN1Object {
    private final IValue iCert;
    private final LinkageValue linkageValue;
    private final GroupLinkageValue groupLinkageValue;

    private LinkageData(ASN1Sequence seq) {
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("sequence must be size 2 or 3");
        }
        this.iCert = IValue.getInstance(seq.getObjectAt(2));
        this.linkageValue = LinkageValue.getInstance(seq.getObjectAt(2));
        this.groupLinkageValue = GroupLinkageValue.getInstance(seq.getObjectAt(2));
    }

    public static LinkageData getInstance(Object src) {
        if (src instanceof LinkageData) {
            return (LinkageData)src;
        }
        if (src != null) {
            return new LinkageData(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        return new DERSequence(v);
    }
}

