/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.agreement;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.crypto.StagedAgreement;
import com.apusic.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.apusic.org.bouncycastle.crypto.params.ECDomainParameters;
import com.apusic.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.apusic.org.bouncycastle.math.ec.ECAlgorithms;
import com.apusic.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCStagedAgreement
implements StagedAgreement {
    ECPrivateKeyParameters key;

    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public AsymmetricKeyParameter calculateStage(CipherParameters pubKey) {
        ECPoint P = this.calculateNextPoint((ECPublicKeyParameters)pubKey);
        return new ECPublicKeyParameters(P, this.key.getParameters());
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPoint P = this.calculateNextPoint((ECPublicKeyParameters)pubKey);
        return P.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateNextPoint(ECPublicKeyParameters pubKey) {
        ECPublicKeyParameters pub = pubKey;
        ECDomainParameters params = this.key.getParameters();
        if (!params.equals(pub.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger hd = params.getH().multiply(this.key.getD()).mod(params.getN());
        ECPoint pubPoint = ECAlgorithms.cleanPoint(params.getCurve(), pub.getQ());
        if (pubPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint P = pubPoint.multiply(hd).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return P;
    }
}

