/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.agreement;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.crypto.Digest;
import com.apusic.org.bouncycastle.crypto.params.ECDomainParameters;
import com.apusic.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithUKM;
import com.apusic.org.bouncycastle.math.ec.ECAlgorithms;
import com.apusic.org.bouncycastle.math.ec.ECPoint;
import com.apusic.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECVKOAgreement {
    private final Digest digest;
    private ECPrivateKeyParameters key;
    private BigInteger ukm;

    public ECVKOAgreement(Digest digest) {
        this.digest = digest;
    }

    public void init(CipherParameters key) {
        ParametersWithUKM p = (ParametersWithUKM)key;
        this.key = (ECPrivateKeyParameters)p.getParameters();
        this.ukm = ECVKOAgreement.toInteger(p.getUKM());
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECDomainParameters params = this.key.getParameters();
        if (!params.equals(pub.getParameters())) {
            throw new IllegalStateException("ECVKO public key has wrong domain parameters");
        }
        BigInteger hd = params.getH().multiply(this.ukm).multiply(this.key.getD()).mod(params.getN());
        ECPoint pubPoint = ECAlgorithms.cleanPoint(params.getCurve(), pub.getQ());
        if (pubPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint P = pubPoint.multiply(hd).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
        }
        return this.fromPoint(P);
    }

    private static BigInteger toInteger(byte[] ukm) {
        byte[] v = new byte[ukm.length];
        for (int i = 0; i != v.length; ++i) {
            v[i] = ukm[ukm.length - i - 1];
        }
        return new BigInteger(1, v);
    }

    private byte[] fromPoint(ECPoint v) {
        int i;
        BigInteger bX = v.getAffineXCoord().toBigInteger();
        BigInteger bY = v.getAffineYCoord().toBigInteger();
        int size = bX.toByteArray().length > 33 ? 64 : 32;
        byte[] bytes = new byte[2 * size];
        byte[] x = BigIntegers.asUnsignedByteArray(size, bX);
        byte[] y = BigIntegers.asUnsignedByteArray(size, bY);
        for (i = 0; i != size; ++i) {
            bytes[i] = x[size - i - 1];
        }
        for (i = 0; i != size; ++i) {
            bytes[size + i] = y[size - i - 1];
        }
        this.digest.update(bytes, 0, bytes.length);
        byte[] rv = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(rv, 0);
        return rv;
    }
}

