/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.agreement.kdf;

import com.apusic.org.bouncycastle.asn1.ASN1EncodableVector;
import com.apusic.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.apusic.org.bouncycastle.asn1.DERNull;
import com.apusic.org.bouncycastle.asn1.DEROctetString;
import com.apusic.org.bouncycastle.asn1.DERSequence;
import com.apusic.org.bouncycastle.asn1.DERTaggedObject;
import com.apusic.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.apusic.org.bouncycastle.crypto.DataLengthException;
import com.apusic.org.bouncycastle.crypto.DerivationParameters;
import com.apusic.org.bouncycastle.crypto.Digest;
import com.apusic.org.bouncycastle.crypto.DigestDerivationFunction;
import com.apusic.org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.apusic.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.apusic.org.bouncycastle.crypto.params.KDFParameters;
import com.apusic.org.bouncycastle.util.Pack;
import java.io.IOException;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
    }

    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too small");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE));
        v.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(v).getEncoded("DER")));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to initialise kdf: " + e.getMessage());
        }
        return this.kdf.generateBytes(out, outOff, len);
    }
}

