/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.crypto.prng;

import com.apusic.org.bouncycastle.crypto.BlockCipher;
import com.apusic.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.apusic.org.bouncycastle.crypto.params.KeyParameter;
import com.apusic.org.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.apusic.org.bouncycastle.crypto.prng.EntropySourceProvider;
import com.apusic.org.bouncycastle.crypto.prng.X931RNG;
import com.apusic.org.bouncycastle.crypto.prng.X931SecureRandom;
import com.apusic.org.bouncycastle.util.Arrays;
import com.apusic.org.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class X931SecureRandomBuilder {
    private SecureRandom random;
    private EntropySourceProvider entropySourceProvider;
    private byte[] dateTimeVector;

    public X931SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public X931SecureRandomBuilder(SecureRandom entropySource, boolean predictionResistant) {
        this.random = entropySource;
        this.entropySourceProvider = new BasicEntropySourceProvider(this.random, predictionResistant);
    }

    public X931SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    public X931SecureRandomBuilder setDateTimeVector(byte[] dateTimeVector) {
        this.dateTimeVector = Arrays.clone(dateTimeVector);
        return this;
    }

    public X931SecureRandom build(BlockCipher engine, KeyParameter key, boolean predictionResistant) {
        if (this.dateTimeVector == null) {
            this.dateTimeVector = new byte[engine.getBlockSize()];
            Pack.longToBigEndian(System.currentTimeMillis(), this.dateTimeVector, 0);
        }
        engine.init(true, key);
        return new X931SecureRandom(this.random, new X931RNG(engine, this.dateTimeVector, this.entropySourceProvider.get(engine.getBlockSize() * 8)), predictionResistant);
    }
}

