/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jcajce.provider.digest;

import com.apusic.org.bouncycastle.crypto.Digest;
import java.security.DigestException;
import java.security.MessageDigest;

public class BCMessageDigest
extends MessageDigest {
    protected Digest digest;
    protected int digestSize;

    protected BCMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    public void engineReset() {
        this.digest.reset();
    }

    public void engineUpdate(byte input) {
        this.digest.update(input);
    }

    public void engineUpdate(byte[] input, int offset, int len) {
        this.digest.update(input, offset, len);
    }

    public int engineGetDigestLength() {
        return this.digestSize;
    }

    public byte[] engineDigest() {
        byte[] digestBytes = new byte[this.digestSize];
        this.digest.doFinal(digestBytes, 0);
        return digestBytes;
    }

    public int engineDigest(byte[] buf, int off, int len) throws DigestException {
        if (len < this.digestSize) {
            throw new DigestException("partial digests not returned");
        }
        if (buf.length - off < this.digestSize) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        this.digest.doFinal(buf, off);
        return this.digestSize;
    }
}

