/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jcajce.provider.digest;

import com.apusic.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.apusic.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.apusic.org.bouncycastle.crypto.CipherKeyGenerator;
import com.apusic.org.bouncycastle.crypto.digests.MD5Digest;
import com.apusic.org.bouncycastle.crypto.macs.HMac;
import com.apusic.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.apusic.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.apusic.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class MD5 {
    private MD5() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD5.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD5", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
            this.addHMACAlgorithm(provider, "MD5", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "MD5", IANAObjectIdentifiers.hmacMD5);
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD5Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD5Digest((MD5Digest)this.digest);
            return d;
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD5", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD5Digest()));
        }
    }
}

