/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jcajce.provider.symmetric;

import com.apusic.org.bouncycastle.crypto.CipherKeyGenerator;
import com.apusic.org.bouncycastle.crypto.engines.XSalsa20Engine;
import com.apusic.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.apusic.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.apusic.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class XSalsa20 {
    private XSalsa20() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XSalsa20.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.XSALSA20", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.XSALSA20", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.XSALSA20", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "XSalsa20 IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XSalsa20", 256, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new XSalsa20Engine(), 24);
        }
    }
}

