/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jsse.provider;

import com.apusic.org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import com.apusic.org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import com.apusic.org.bouncycastle.jsse.provider.FipsUtils;
import com.apusic.org.bouncycastle.jsse.provider.JsseUtils;
import com.apusic.org.bouncycastle.jsse.provider.PropertyUtils;
import com.apusic.org.bouncycastle.jsse.provider.ProvSSLParameters;
import com.apusic.org.bouncycastle.tls.NamedGroup;
import com.apusic.org.bouncycastle.tls.ProtocolVersion;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.apusic.org.bouncycastle.util.Arrays;
import com.apusic.org.bouncycastle.util.Integers;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedGroupInfo {
    private static final Logger LOG = Logger.getLogger(NamedGroupInfo.class.getName());
    private static final String PROPERTY_NAMED_GROUPS = "jdk.tls.namedGroups";
    private static final int[] CANDIDATES_DEFAULT = new int[]{29, 30, 23, 24, 25, 31, 32, 33, 256, 257, 258, 41};
    private final All all;
    private final AlgorithmParameters algorithmParameters;
    private final boolean enabled;

    static PerConnection createPerConnection(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        Map<Integer, NamedGroupInfo> local = NamedGroupInfo.createLocal(perContext, sslParameters, activeProtocolVersions);
        boolean localECDSA = NamedGroupInfo.createLocalECDSA(local);
        return new PerConnection(local, localECDSA);
    }

    static PerContext createPerContext(boolean isFipsContext, JcaTlsCrypto crypto) {
        Map<Integer, NamedGroupInfo> index = NamedGroupInfo.createIndex(isFipsContext, crypto);
        int[] candidates = NamedGroupInfo.createCandidates(index);
        return new PerContext(index, candidates);
    }

    static int getMaximumBitsServerECDH(PerConnection perConnection) {
        int maxBits = 0;
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            maxBits = Math.max(maxBits, namedGroupInfo.getBitsECDH());
        }
        return maxBits;
    }

    static int getMaximumBitsServerFFDHE(PerConnection perConnection) {
        int maxBits = 0;
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            maxBits = Math.max(maxBits, namedGroupInfo.getBitsFFDHE());
        }
        return maxBits;
    }

    static NamedGroupInfo getNamedGroup(PerContext perContext, int namedGroup) {
        return (NamedGroupInfo)perContext.index.get(namedGroup);
    }

    static Vector<Integer> getSupportedGroupsLocalClient(PerConnection perConnection) {
        return new Vector<Integer>(perConnection.local.keySet());
    }

    static int[] getSupportedGroupsLocalServer(PerConnection perConnection) {
        Set keys = perConnection.local.keySet();
        int count = keys.size();
        int pos = 0;
        int[] result = new int[count];
        for (Integer key : keys) {
            result[pos++] = key;
        }
        return result;
    }

    static boolean hasAnyECDSALocal(PerConnection perConnection) {
        return perConnection.localECDSA;
    }

    static boolean hasLocal(PerConnection perConnection, int namedGroup) {
        return perConnection.local.containsKey(namedGroup);
    }

    static void notifyPeer(PerConnection perConnection, int[] peerNamedGroups) {
        List<NamedGroupInfo> peer = NamedGroupInfo.createPeer(perConnection, peerNamedGroups);
        perConnection.setPeer(peer);
    }

    static int selectServerECDH(PerConnection perConnection, int minimumBitsECDH) {
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            if (namedGroupInfo.getBitsECDH() < minimumBitsECDH) continue;
            return namedGroupInfo.getNamedGroup();
        }
        return -1;
    }

    static int selectServerFFDHE(PerConnection perConnection, int minimumBitsFFDHE) {
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            if (namedGroupInfo.getBitsFFDHE() < minimumBitsFFDHE) continue;
            return namedGroupInfo.getNamedGroup();
        }
        return -1;
    }

    private static void addNamedGroup(boolean isFipsContext, JcaTlsCrypto crypto, boolean disableChar2, boolean disableFFDHE, Map<Integer, NamedGroupInfo> ng, All all) {
        int namedGroup = all.namedGroup;
        if (isFipsContext && !FipsUtils.isFipsNamedGroup(namedGroup)) {
            return;
        }
        boolean disable = disableChar2 && all.char2 || disableFFDHE && all.bitsFFDHE > 0;
        boolean enabled = !disable && null != all.jcaGroup && crypto.hasNamedGroup(namedGroup);
        AlgorithmParameters algorithmParameters = null;
        if (enabled) {
            try {
                algorithmParameters = crypto.getNamedGroupAlgorithmParameters(namedGroup);
            }
            catch (Exception e) {
                enabled = false;
            }
        }
        NamedGroupInfo namedGroupInfo = new NamedGroupInfo(all, algorithmParameters, enabled);
        if (null != ng.put(namedGroup, namedGroupInfo)) {
            throw new IllegalStateException("Duplicate entries for NamedGroupInfo");
        }
    }

    private static int[] createCandidates(Map<Integer, NamedGroupInfo> index) {
        String[] names = PropertyUtils.getStringArraySystemProperty(PROPERTY_NAMED_GROUPS);
        if (null == names) {
            return CANDIDATES_DEFAULT;
        }
        int[] result = new int[names.length];
        int count = 0;
        for (String name : names) {
            int namedGroup = NamedGroupInfo.getNamedGroupByName(name);
            if (namedGroup < 0) {
                LOG.warning("'jdk.tls.namedGroups' contains unrecognised NamedGroup: " + name);
                continue;
            }
            NamedGroupInfo namedGroupInfo = index.get(namedGroup);
            if (null == namedGroupInfo) {
                LOG.warning("'jdk.tls.namedGroups' contains unsupported NamedGroup: " + name);
                continue;
            }
            if (!namedGroupInfo.isEnabled()) {
                LOG.warning("'jdk.tls.namedGroups' contains disabled NamedGroup: " + name);
                continue;
            }
            result[count++] = namedGroup;
        }
        if (count < result.length) {
            result = Arrays.copyOf(result, count);
        }
        if (result.length < 1) {
            LOG.severe("'jdk.tls.namedGroups' contained no usable NamedGroup values");
        }
        return result;
    }

    private static Map<Integer, NamedGroupInfo> createIndex(boolean isFipsContext, JcaTlsCrypto crypto) {
        TreeMap<Integer, NamedGroupInfo> ng = new TreeMap<Integer, NamedGroupInfo>();
        boolean disableChar2 = PropertyUtils.getBooleanSystemProperty("com.apusic.org.bouncycastle.jsse.ec.disableChar2", false) || PropertyUtils.getBooleanSystemProperty("com.apusic.org.bouncycastle.ec.disable_f2m", false);
        boolean disableFFDHE = !PropertyUtils.getBooleanSystemProperty("jsse.enableFFDHE", true);
        for (All all : All.values()) {
            NamedGroupInfo.addNamedGroup(isFipsContext, crypto, disableChar2, disableFFDHE, ng, all);
        }
        return ng;
    }

    private static Map<Integer, NamedGroupInfo> createLocal(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        ProtocolVersion latest = ProtocolVersion.getLatestTLS(activeProtocolVersions);
        ProtocolVersion earliest = ProtocolVersion.getEarliestTLS(activeProtocolVersions);
        ProtocolVersion gmTLS = ProtocolVersion.getLatestGMTLS(activeProtocolVersions);
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        boolean post13Active = false;
        boolean pre13Active = false;
        boolean gmtls11Active = false;
        if (latest != null) {
            post13Active = TlsUtils.isTLSv13(latest);
        }
        if (earliest != null) {
            boolean bl = pre13Active = !TlsUtils.isTLSv13(earliest);
        }
        if (gmTLS != null) {
            gmtls11Active = true;
        }
        int count = perContext.candidates.length;
        LinkedHashMap<Integer, NamedGroupInfo> result = new LinkedHashMap<Integer, NamedGroupInfo>(count);
        for (int i = 0; i < count; ++i) {
            Integer candidate = Integers.valueOf(perContext.candidates[i]);
            NamedGroupInfo namedGroupInfo = (NamedGroupInfo)perContext.index.get(candidate);
            if (null == namedGroupInfo || !namedGroupInfo.isActive(algorithmConstraints, post13Active, pre13Active) && !namedGroupInfo.isActive(algorithmConstraints, gmtls11Active)) continue;
            result.put(candidate, namedGroupInfo);
        }
        return result;
    }

    private static boolean createLocalECDSA(Map<Integer, NamedGroupInfo> local) {
        for (NamedGroupInfo namedGroupInfo : local.values()) {
            if (!NamedGroup.refersToAnECDSACurve(namedGroupInfo.getNamedGroup())) continue;
            return true;
        }
        return false;
    }

    private static List<NamedGroupInfo> createPeer(PerConnection perConnection, int[] peerNamedGroups) {
        return NamedGroupInfo.getNamedGroupInfos(perConnection.local, peerNamedGroups);
    }

    private static Collection<NamedGroupInfo> getEffectivePeer(PerConnection perConnection) {
        List<NamedGroupInfo> peer = perConnection.getPeer();
        if (!peer.isEmpty()) {
            return peer;
        }
        return perConnection.local.values();
    }

    private static int getNamedGroupByName(String name) {
        for (All all : All.values()) {
            if (!all.name.equalsIgnoreCase(name)) continue;
            return all.namedGroup;
        }
        return -1;
    }

    private static List<NamedGroupInfo> getNamedGroupInfos(Map<Integer, NamedGroupInfo> namedGroupInfos, int[] namedGroups) {
        if (TlsUtils.isNullOrEmpty(namedGroups)) {
            return Collections.emptyList();
        }
        int count = namedGroups.length;
        ArrayList<NamedGroupInfo> result = new ArrayList<NamedGroupInfo>(count);
        for (int i = 0; i < count; ++i) {
            int namedGroup = namedGroups[i];
            NamedGroupInfo namedGroupInfo = namedGroupInfos.get(namedGroup);
            if (null == namedGroupInfo) continue;
            result.add(namedGroupInfo);
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        result.trimToSize();
        return result;
    }

    NamedGroupInfo(All all, AlgorithmParameters algorithmParameters, boolean enabled) {
        this.all = all;
        this.algorithmParameters = algorithmParameters;
        this.enabled = enabled;
    }

    int getBitsECDH() {
        return this.all.bitsECDH;
    }

    int getBitsFFDHE() {
        return this.all.bitsFFDHE;
    }

    String getJcaAlgorithm() {
        return this.all.jcaAlgorithm;
    }

    String getJcaGroup() {
        return this.all.jcaGroup;
    }

    int getNamedGroup() {
        return this.all.namedGroup;
    }

    boolean isActive(BCAlgorithmConstraints algorithmConstraints, boolean post13Active, boolean pre13Active) {
        return this.enabled && (post13Active && this.isSupportedPost13() || pre13Active && this.isSupportedPre13()) && this.isPermittedBy(algorithmConstraints);
    }

    boolean isActive(BCAlgorithmConstraints algorithmConstraints, boolean gmtls11Active) {
        return this.enabled && gmtls11Active && this.isSupportedGMTLS11() && this.isPermittedBy(algorithmConstraints);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isSupportedPost13() {
        return this.all.supportedPost13;
    }

    boolean isSupportedPre13() {
        return this.all.supportedPre13;
    }

    boolean isSupportedGMTLS11() {
        return this.all.supportedGMTLS11;
    }

    public String toString() {
        return this.all.text;
    }

    private boolean isPermittedBy(BCAlgorithmConstraints algorithmConstraints) {
        Set<BCCryptoPrimitive> primitives = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
        return algorithmConstraints.permits(primitives, this.getJcaGroup(), null) && algorithmConstraints.permits(primitives, this.getJcaAlgorithm(), this.algorithmParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerContext {
        private final Map<Integer, NamedGroupInfo> index;
        private final int[] candidates;

        PerContext(Map<Integer, NamedGroupInfo> index, int[] candidates) {
            this.index = index;
            this.candidates = candidates;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerConnection {
        private final Map<Integer, NamedGroupInfo> local;
        private final boolean localECDSA;
        private List<NamedGroupInfo> peer;

        PerConnection(Map<Integer, NamedGroupInfo> local, boolean localECDSA) {
            this.local = local;
            this.localECDSA = localECDSA;
            this.peer = null;
        }

        public synchronized List<NamedGroupInfo> getPeer() {
            return this.peer;
        }

        private synchronized void setPeer(List<NamedGroupInfo> peer) {
            this.peer = peer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum All {
        sect163k1(1, "EC"),
        sect163r1(2, "EC"),
        sect163r2(3, "EC"),
        sect193r1(4, "EC"),
        sect193r2(5, "EC"),
        sect233k1(6, "EC"),
        sect233r1(7, "EC"),
        sect239k1(8, "EC"),
        sect283k1(9, "EC"),
        sect283r1(10, "EC"),
        sect409k1(11, "EC"),
        sect409r1(12, "EC"),
        sect571k1(13, "EC"),
        sect571r1(14, "EC"),
        secp160k1(15, "EC"),
        secp160r1(16, "EC"),
        secp160r2(17, "EC"),
        secp192k1(18, "EC"),
        secp192r1(19, "EC"),
        secp224k1(20, "EC"),
        secp224r1(21, "EC"),
        secp256k1(22, "EC"),
        secp256r1(23, "EC"),
        secp384r1(24, "EC"),
        secp521r1(25, "EC"),
        brainpoolP256r1(26, "EC"),
        brainpoolP384r1(27, "EC"),
        brainpoolP512r1(28, "EC"),
        x25519(29, "XDH"),
        x448(30, "XDH"),
        brainpoolP256r1tls13(31, "EC"),
        brainpoolP384r1tls13(32, "EC"),
        brainpoolP512r1tls13(33, "EC"),
        curveSM2(41, "EC"),
        ffdhe2048(256, "DiffieHellman"),
        ffdhe3072(257, "DiffieHellman"),
        ffdhe4096(258, "DiffieHellman"),
        ffdhe6144(259, "DiffieHellman"),
        ffdhe8192(260, "DiffieHellman");

        private final int namedGroup;
        private final String name;
        private final String text;
        private final String jcaAlgorithm;
        private final String jcaGroup;
        private final boolean char2;
        private final boolean supportedPost13;
        private final boolean supportedPre13;
        private final boolean supportedGMTLS11;
        private final int bitsECDH;
        private final int bitsFFDHE;

        private All(int namedGroup, String jcaAlgorithm) {
            this.namedGroup = namedGroup;
            this.name = NamedGroup.getName(namedGroup);
            this.text = NamedGroup.getText(namedGroup);
            this.jcaAlgorithm = jcaAlgorithm;
            this.jcaGroup = NamedGroup.getStandardName(namedGroup);
            this.supportedPost13 = NamedGroup.canBeNegotiated(namedGroup, ProtocolVersion.TLSv13);
            this.supportedPre13 = NamedGroup.canBeNegotiated(namedGroup, ProtocolVersion.TLSv12);
            this.supportedGMTLS11 = NamedGroup.canBeNegotiated(namedGroup, ProtocolVersion.GMTLSv11);
            this.char2 = NamedGroup.isChar2Curve(namedGroup);
            this.bitsECDH = NamedGroup.getCurveBits(namedGroup);
            this.bitsFFDHE = NamedGroup.getFiniteFieldBits(namedGroup);
        }
    }
}

