/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jsse.provider;

import com.apusic.org.bouncycastle.jsse.provider.CipherSuiteInfo;
import com.apusic.org.bouncycastle.jsse.provider.JcaAlgorithmDecomposer;
import com.apusic.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import com.apusic.org.bouncycastle.tls.CipherSuite;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvAlgorithmDecomposer
extends JcaAlgorithmDecomposer {
    static final ProvAlgorithmDecomposer INSTANCE_TLS = new ProvAlgorithmDecomposer(true);
    static final ProvAlgorithmDecomposer INSTANCE_X509 = new ProvAlgorithmDecomposer(false);
    private final boolean enableTLSAlgorithms;

    private ProvAlgorithmDecomposer(boolean enableTLSAlgorithms) {
        this.enableTLSAlgorithms = enableTLSAlgorithms;
    }

    @Override
    public Set<String> decompose(String algorithm) {
        CipherSuiteInfo cipherSuiteInfo;
        if (algorithm.startsWith("TLS_") && null != (cipherSuiteInfo = ProvSSLContextSpi.getCipherSuiteInfo(algorithm)) && !CipherSuite.isSCSV(cipherSuiteInfo.getCipherSuite())) {
            return this.enableTLSAlgorithms ? cipherSuiteInfo.getDecompositionTLS() : cipherSuiteInfo.getDecompositionX509();
        }
        return super.decompose(algorithm);
    }
}

