/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.jsse.provider;

import com.apusic.org.bouncycastle.jsse.BCSNIServerName;
import com.apusic.org.bouncycastle.jsse.provider.JsseSecurityParameters;
import com.apusic.org.bouncycastle.jsse.provider.JsseSessionParameters;
import com.apusic.org.bouncycastle.jsse.provider.JsseUtils;
import com.apusic.org.bouncycastle.jsse.provider.ProvSSLSessionBase;
import com.apusic.org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import com.apusic.org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import com.apusic.org.bouncycastle.tls.Certificate;
import com.apusic.org.bouncycastle.tls.ProtocolVersion;
import com.apusic.org.bouncycastle.tls.SecurityParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLSessionHandshake
extends ProvSSLSessionBase {
    protected final SecurityParameters securityParameters;
    protected final JsseSecurityParameters jsseSecurityParameters;

    ProvSSLSessionHandshake(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters) {
        super(sslSessionContext, peerHost, peerPort);
        this.securityParameters = securityParameters;
        this.jsseSecurityParameters = jsseSecurityParameters;
    }

    String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.securityParameters);
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.securityParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.securityParameters.getSessionID();
    }

    @Override
    protected JsseSecurityParameters getJsseSecurityParameters() {
        return this.jsseSecurityParameters;
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return null;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.securityParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.jsseSecurityParameters.localSigSchemesCert);
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithmsBC() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.jsseSecurityParameters.localSigSchemesCert);
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.securityParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.jsseSecurityParameters.peerSigSchemesCert);
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithmsBC() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.jsseSecurityParameters.peerSigSchemesCert);
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.securityParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        Vector clientServerNames = this.securityParameters.getClientServerNames();
        return JsseUtils.convertSNIServerNames(clientServerNames);
    }

    @Override
    public List<byte[]> getStatusResponses() {
        List<byte[]> statusResponses = this.jsseSecurityParameters.statusResponses;
        if (null == statusResponses || statusResponses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(statusResponses.size());
        for (byte[] statusResponse : statusResponses) {
            result.add(statusResponse.clone());
        }
        return Collections.unmodifiableList(result);
    }
}

