/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.gmss;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.apusic.org.bouncycastle.crypto.Digest;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.apusic.org.bouncycastle.pqc.crypto.MessageSigner;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import com.apusic.org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.apusic.org.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil gmssUtil = new GMSSUtil();
    private byte[] pubKeyBytes;
    private Digest messDigestTrees;
    private int mdLength;
    private int numLayer;
    private Digest messDigestOTS;
    private WinternitzOTSignature ots;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private byte[][][] currentAuthPaths;
    private byte[][] subtreeRootSig;
    private GMSSParameters gmssPS;
    private GMSSRandom gmssRandom;
    GMSSKeyParameters key;
    private SecureRandom random;

    public GMSSSigner(GMSSDigestProvider digest) {
        this.digestProvider = digest;
        this.messDigestOTS = this.messDigestTrees = digest.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (GMSSPrivateKeyParameters)rParam.getParameters();
                this.initSign();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (GMSSPrivateKeyParameters)param;
                this.initSign();
            }
        } else {
            this.key = (GMSSPublicKeyParameters)param;
            this.initVerify();
        }
    }

    private void initSign() {
        int i;
        this.messDigestTrees.reset();
        GMSSPrivateKeyParameters gmssPrivateKey = (GMSSPrivateKeyParameters)this.key;
        if (gmssPrivateKey.isUsed()) {
            throw new IllegalStateException("Private key already used");
        }
        if (gmssPrivateKey.getIndex(0) >= gmssPrivateKey.getNumLeafs(0)) {
            throw new IllegalStateException("No more signatures can be generated");
        }
        this.gmssPS = gmssPrivateKey.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
        byte[] seed = gmssPrivateKey.getCurrentSeeds()[this.numLayer - 1];
        byte[] OTSSeed = new byte[this.mdLength];
        byte[] dummy = new byte[this.mdLength];
        System.arraycopy(seed, 0, dummy, 0, this.mdLength);
        OTSSeed = this.gmssRandom.nextSeed(dummy);
        this.ots = new WinternitzOTSignature(OTSSeed, this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[this.numLayer - 1]);
        byte[][][] helpCurrentAuthPaths = gmssPrivateKey.getCurrentAuthPaths();
        this.currentAuthPaths = new byte[this.numLayer][][];
        for (int j = 0; j < this.numLayer; ++j) {
            this.currentAuthPaths[j] = new byte[helpCurrentAuthPaths[j].length][this.mdLength];
            for (i = 0; i < helpCurrentAuthPaths[j].length; ++i) {
                System.arraycopy(helpCurrentAuthPaths[j][i], 0, this.currentAuthPaths[j][i], 0, this.mdLength);
            }
        }
        this.index = new int[this.numLayer];
        System.arraycopy(gmssPrivateKey.getIndex(), 0, this.index, 0, this.numLayer);
        this.subtreeRootSig = new byte[this.numLayer - 1][];
        for (i = 0; i < this.numLayer - 1; ++i) {
            byte[] helpSubtreeRootSig = gmssPrivateKey.getSubtreeRootSig(i);
            this.subtreeRootSig[i] = new byte[helpSubtreeRootSig.length];
            System.arraycopy(helpSubtreeRootSig, 0, this.subtreeRootSig[i], 0, helpSubtreeRootSig.length);
        }
        gmssPrivateKey.markUsed();
    }

    public byte[] generateSignature(byte[] message) {
        byte[] otsSig = new byte[this.mdLength];
        otsSig = this.ots.getSignature(message);
        byte[] authPathBytes = this.gmssUtil.concatenateArray(this.currentAuthPaths[this.numLayer - 1]);
        byte[] indexBytes = this.gmssUtil.intToBytesLittleEndian(this.index[this.numLayer - 1]);
        byte[] gmssSigFirstPart = new byte[indexBytes.length + otsSig.length + authPathBytes.length];
        System.arraycopy(indexBytes, 0, gmssSigFirstPart, 0, indexBytes.length);
        System.arraycopy(otsSig, 0, gmssSigFirstPart, indexBytes.length, otsSig.length);
        System.arraycopy(authPathBytes, 0, gmssSigFirstPart, indexBytes.length + otsSig.length, authPathBytes.length);
        byte[] gmssSigNextPart = new byte[]{};
        for (int i = this.numLayer - 1 - 1; i >= 0; --i) {
            authPathBytes = this.gmssUtil.concatenateArray(this.currentAuthPaths[i]);
            indexBytes = this.gmssUtil.intToBytesLittleEndian(this.index[i]);
            byte[] helpGmssSig = new byte[gmssSigNextPart.length];
            System.arraycopy(gmssSigNextPart, 0, helpGmssSig, 0, gmssSigNextPart.length);
            gmssSigNextPart = new byte[helpGmssSig.length + indexBytes.length + this.subtreeRootSig[i].length + authPathBytes.length];
            System.arraycopy(helpGmssSig, 0, gmssSigNextPart, 0, helpGmssSig.length);
            System.arraycopy(indexBytes, 0, gmssSigNextPart, helpGmssSig.length, indexBytes.length);
            System.arraycopy(this.subtreeRootSig[i], 0, gmssSigNextPart, helpGmssSig.length + indexBytes.length, this.subtreeRootSig[i].length);
            System.arraycopy(authPathBytes, 0, gmssSigNextPart, helpGmssSig.length + indexBytes.length + this.subtreeRootSig[i].length, authPathBytes.length);
        }
        byte[] gmssSig = new byte[gmssSigFirstPart.length + gmssSigNextPart.length];
        System.arraycopy(gmssSigFirstPart, 0, gmssSig, 0, gmssSigFirstPart.length);
        System.arraycopy(gmssSigNextPart, 0, gmssSig, gmssSigFirstPart.length, gmssSigNextPart.length);
        return gmssSig;
    }

    private void initVerify() {
        this.messDigestTrees.reset();
        GMSSPublicKeyParameters gmssPublicKey = (GMSSPublicKeyParameters)this.key;
        this.pubKeyBytes = gmssPublicKey.getPublicKey();
        this.gmssPS = gmssPublicKey.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        boolean success = false;
        this.messDigestOTS.reset();
        byte[] help = message;
        int nextEntry = 0;
        for (int j = this.numLayer - 1; j >= 0; --j) {
            WinternitzOTSVerify otsVerify = new WinternitzOTSVerify(this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[j]);
            int otsSigLength = otsVerify.getSignatureLength();
            message = help;
            int index = this.gmssUtil.bytesToIntLittleEndian(signature, nextEntry);
            byte[] otsSig = new byte[otsSigLength];
            System.arraycopy(signature, nextEntry += 4, otsSig, 0, otsSigLength);
            nextEntry += otsSigLength;
            byte[] otsPublicKey = otsVerify.Verify(message, otsSig);
            if (otsPublicKey == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] authPath = new byte[this.gmssPS.getHeightOfTrees()[j]][this.mdLength];
            for (int i = 0; i < authPath.length; ++i) {
                System.arraycopy(signature, nextEntry, authPath[i], 0, this.mdLength);
                nextEntry += this.mdLength;
            }
            help = new byte[this.mdLength];
            help = otsPublicKey;
            int count = 1 << authPath.length;
            count += index;
            for (int i = 0; i < authPath.length; ++i) {
                byte[] dest = new byte[this.mdLength << 1];
                if (count % 2 == 0) {
                    System.arraycopy(help, 0, dest, 0, this.mdLength);
                    System.arraycopy(authPath[i], 0, dest, this.mdLength, this.mdLength);
                    count /= 2;
                } else {
                    System.arraycopy(authPath[i], 0, dest, 0, this.mdLength);
                    System.arraycopy(help, 0, dest, this.mdLength, help.length);
                    count = (count - 1) / 2;
                }
                this.messDigestTrees.update(dest, 0, dest.length);
                help = new byte[this.messDigestTrees.getDigestSize()];
                this.messDigestTrees.doFinal(help, 0);
            }
        }
        if (Arrays.areEqual(this.pubKeyBytes, help)) {
            success = true;
        }
        return success;
    }
}

