/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.lms;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.pqc.crypto.MessageSigner;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSS;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSSignature;
import java.io.IOException;

public class HSSSigner
implements MessageSigner {
    private HSSPrivateKeyParameters privKey;
    private HSSPublicKeyParameters pubKey;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (HSSPrivateKeyParameters)param;
        } else {
            this.pubKey = (HSSPublicKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        try {
            return HSS.generateSignature(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return HSS.verifySignature(this.pubKey, HSSSignature.getInstance(signature, this.pubKey.getL()), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

