/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.lms;

import com.apusic.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.apusic.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import java.util.HashMap;
import java.util.Map;

public class LMOtsParameters {
    public static final int reserved = 0;
    public static final LMOtsParameters sha256_n32_w1 = new LMOtsParameters(1, 32, 1, 265, 7, 8516, NISTObjectIdentifiers.id_sha256);
    public static final LMOtsParameters sha256_n32_w2 = new LMOtsParameters(2, 32, 2, 133, 6, 4292, NISTObjectIdentifiers.id_sha256);
    public static final LMOtsParameters sha256_n32_w4 = new LMOtsParameters(3, 32, 4, 67, 4, 2180, NISTObjectIdentifiers.id_sha256);
    public static final LMOtsParameters sha256_n32_w8 = new LMOtsParameters(4, 32, 8, 34, 0, 1124, NISTObjectIdentifiers.id_sha256);
    private static final Map<Object, LMOtsParameters> suppliers = new HashMap<Object, LMOtsParameters>(){
        {
            this.put(sha256_n32_w1.type, sha256_n32_w1);
            this.put(sha256_n32_w2.type, sha256_n32_w2);
            this.put(sha256_n32_w4.type, sha256_n32_w4);
            this.put(sha256_n32_w8.type, sha256_n32_w8);
        }
    };
    private final int type;
    private final int n;
    private final int w;
    private final int p;
    private final int ls;
    private final int sigLen;
    private final ASN1ObjectIdentifier digestOID;

    protected LMOtsParameters(int type, int n, int w, int p, int ls, int sigLen, ASN1ObjectIdentifier digestOID) {
        this.type = type;
        this.n = n;
        this.w = w;
        this.p = p;
        this.ls = ls;
        this.sigLen = sigLen;
        this.digestOID = digestOID;
    }

    public int getType() {
        return this.type;
    }

    public int getN() {
        return this.n;
    }

    public int getW() {
        return this.w;
    }

    public int getP() {
        return this.p;
    }

    public int getLs() {
        return this.ls;
    }

    public int getSigLen() {
        return this.sigLen;
    }

    public ASN1ObjectIdentifier getDigestOID() {
        return this.digestOID;
    }

    public static LMOtsParameters getParametersForType(int type) {
        return suppliers.get(type);
    }
}

