/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.lms;

import com.apusic.org.bouncycastle.pqc.crypto.lms.Composer;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.apusic.org.bouncycastle.util.Encodable;
import java.io.IOException;

class LMSSignedPubKey
implements Encodable {
    private final LMSSignature signature;
    private final LMSPublicKeyParameters publicKey;

    public LMSSignedPubKey(LMSSignature signature, LMSPublicKeyParameters publicKey) {
        this.signature = signature;
        this.publicKey = publicKey;
    }

    public LMSSignature getSignature() {
        return this.signature;
    }

    public LMSPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMSSignedPubKey that = (LMSSignedPubKey)o;
        if (this.signature != null ? !this.signature.equals(that.signature) : that.signature != null) {
            return false;
        }
        return this.publicKey != null ? this.publicKey.equals(that.publicKey) : that.publicKey == null;
    }

    public int hashCode() {
        int result = this.signature != null ? this.signature.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }

    public byte[] getEncoded() throws IOException {
        return Composer.compose().bytes(this.signature.getEncoded()).bytes(this.publicKey.getEncoded()).build();
    }
}

