/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.lms;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.pqc.crypto.MessageSigner;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMS;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSSignature;
import java.io.IOException;

public class LMSSigner
implements MessageSigner {
    private LMSPrivateKeyParameters privKey;
    private LMSPublicKeyParameters pubKey;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (LMSPrivateKeyParameters)param;
        } else {
            this.pubKey = (LMSPublicKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        try {
            return LMS.generateSign(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return LMS.verifySignature(this.pubKey, LMSSignature.getInstance(signature), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

