/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.lms;

import com.apusic.org.bouncycastle.crypto.Digest;

class SeedDerive {
    private final byte[] I;
    private final byte[] masterSeed;
    private final Digest digest;
    private int q;
    private int j;

    public SeedDerive(byte[] I, byte[] masterSeed, Digest digest) {
        this.I = I;
        this.masterSeed = masterSeed;
        this.digest = digest;
    }

    public int getQ() {
        return this.q;
    }

    public void setQ(int q) {
        this.q = q;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public byte[] getI() {
        return this.I;
    }

    public byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public byte[] deriveSeed(byte[] target, int offset) {
        if (target.length < this.digest.getDigestSize()) {
            throw new IllegalArgumentException("target length is less than digest size.");
        }
        this.digest.update(this.I, 0, this.I.length);
        this.digest.update((byte)(this.q >>> 24));
        this.digest.update((byte)(this.q >>> 16));
        this.digest.update((byte)(this.q >>> 8));
        this.digest.update((byte)this.q);
        this.digest.update((byte)(this.j >>> 8));
        this.digest.update((byte)this.j);
        this.digest.update((byte)-1);
        this.digest.update(this.masterSeed, 0, this.masterSeed.length);
        this.digest.doFinal(target, offset);
        return target;
    }

    public void deriveSeed(byte[] target, boolean incJ) {
        this.deriveSeed(target, incJ, 0);
    }

    public void deriveSeed(byte[] target, boolean incJ, int offset) {
        this.deriveSeed(target, offset);
        if (incJ) {
            ++this.j;
        }
    }
}

