/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.apusic.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.apusic.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.apusic.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.apusic.org.bouncycastle.pqc.asn1.McEliecePublicKey;
import com.apusic.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.apusic.org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.io.IOException;
import java.security.PublicKey;

public class BCMcEliecePublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private McEliecePublicKeyParameters params;

    public BCMcEliecePublicKey(McEliecePublicKeyParameters params) {
        this.params = params;
    }

    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public int getT() {
        return this.params.getT();
    }

    public GF2Matrix getG() {
        return this.params.getG();
    }

    public String toString() {
        String result = "McEliecePublicKey:\n";
        result = result + " length of the code         : " + this.params.getN() + "\n";
        result = result + " error correction capability: " + this.params.getT() + "\n";
        result = result + " generator matrix           : " + this.params.getG();
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof BCMcEliecePublicKey) {
            BCMcEliecePublicKey otherKey = (BCMcEliecePublicKey)other;
            return this.params.getN() == otherKey.getN() && this.params.getT() == otherKey.getT() && this.params.getG().equals(otherKey.getG());
        }
        return false;
    }

    public int hashCode() {
        return 37 * (this.params.getN() + 37 * this.params.getT()) + this.params.getG().hashCode();
    }

    public byte[] getEncoded() {
        McEliecePublicKey key = new McEliecePublicKey(this.params.getN(), this.params.getT(), this.params.getG());
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, key);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

