/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.apusic.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.apusic.org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class McElieceKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePublicKey) {
            BCMcEliecePublicKey k = (BCMcEliecePublicKey)key;
            return k.getKeyParams();
        }
        throw new InvalidKeyException("can't identify McEliece public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePrivateKey) {
            BCMcEliecePrivateKey k = (BCMcEliecePrivateKey)key;
            return new McEliecePrivateKeyParameters(k.getN(), k.getK(), k.getField(), k.getGoppaPoly(), k.getP1(), k.getP2(), k.getSInv());
        }
        throw new InvalidKeyException("can't identify McEliece private key.");
    }
}

