/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.qtesla;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.apusic.org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyPairGenerator;
import com.apusic.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import com.apusic.org.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import com.apusic.org.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final Map catLookup = new HashMap();
    private QTESLAKeyGenerationParameters param;
    private QTESLAKeyPairGenerator engine = new QTESLAKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("qTESLA");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof QTESLAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a QTESLAParameterSpec");
        }
        QTESLAParameterSpec qteslaParams = (QTESLAParameterSpec)params;
        this.param = new QTESLAKeyGenerationParameters((Integer)catLookup.get(qteslaParams.getSecurityCategory()), random);
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new QTESLAKeyGenerationParameters(6, this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        QTESLAPublicKeyParameters pub = (QTESLAPublicKeyParameters)pair.getPublic();
        QTESLAPrivateKeyParameters priv = (QTESLAPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCqTESLAPublicKey(pub), new BCqTESLAPrivateKey(priv));
    }

    static {
        catLookup.put(QTESLASecurityCategory.getName(5), Integers.valueOf(5));
        catLookup.put(QTESLASecurityCategory.getName(6), Integers.valueOf(6));
    }
}

