/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.rainbow;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyPairGenerator;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import com.apusic.org.bouncycastle.pqc.jcajce.spec.RainbowParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RainbowKeyPairGeneratorSpi
extends KeyPairGenerator {
    RainbowKeyGenerationParameters param;
    RainbowKeyPairGenerator engine = new RainbowKeyPairGenerator();
    int strength = 1024;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public RainbowKeyPairGeneratorSpi() {
        super("Rainbow");
    }

    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RainbowParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RainbowParameterSpec");
        }
        RainbowParameterSpec rainbowParams = (RainbowParameterSpec)params;
        this.param = new RainbowKeyGenerationParameters(random, new RainbowParameters(rainbowParams.getVi()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new RainbowKeyGenerationParameters(this.random, new RainbowParameters(new RainbowParameterSpec().getVi()));
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        RainbowPublicKeyParameters pub = (RainbowPublicKeyParameters)pair.getPublic();
        RainbowPrivateKeyParameters priv = (RainbowPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCRainbowPublicKey(pub), new BCRainbowPrivateKey(priv));
    }
}

