/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.sphincs;

import com.apusic.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.apusic.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.crypto.Digest;
import com.apusic.org.bouncycastle.crypto.digests.SHA3Digest;
import com.apusic.org.bouncycastle.crypto.digests.SHA512Digest;
import com.apusic.org.bouncycastle.crypto.digests.SHA512tDigest;
import com.apusic.org.bouncycastle.pqc.crypto.sphincs.SPHINCS256Signer;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    private final ASN1ObjectIdentifier treeDigest;
    private Digest digest;
    private SPHINCS256Signer signer;
    private SecureRandom random;

    protected SignatureSpi(Digest digest, ASN1ObjectIdentifier treeDigest, SPHINCS256Signer signer) {
        this.digest = digest;
        this.treeDigest = treeDigest;
        this.signer = signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        BCSphincs256PublicKey key;
        if (publicKey instanceof BCSphincs256PublicKey) {
            key = (BCSphincs256PublicKey)publicKey;
            if (!this.treeDigest.equals(key.getTreeDigest())) {
                throw new InvalidKeyException("SPHINCS-256 signature for tree digest: " + key.getTreeDigest());
            }
        } else {
            throw new InvalidKeyException("unknown public key passed to SPHINCS-256");
        }
        CipherParameters param = key.getKeyParams();
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        BCSphincs256PrivateKey key;
        if (privateKey instanceof BCSphincs256PrivateKey) {
            key = (BCSphincs256PrivateKey)privateKey;
            if (!this.treeDigest.equals(key.getTreeDigest())) {
                throw new InvalidKeyException("SPHINCS-256 signature for tree digest: " + key.getTreeDigest());
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to SPHINCS-256");
        }
        CipherParameters param = key.getKeyParams();
        this.digest.reset();
        this.signer.init(true, param);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] sig = this.signer.generateSignature(hash);
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return this.signer.verifySignature(hash, sigBytes);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha3_512
    extends SignatureSpi {
        public withSha3_512() {
            super(new SHA3Digest(512), NISTObjectIdentifiers.id_sha3_256, new SPHINCS256Signer(new SHA3Digest(256), new SHA3Digest(512)));
        }
    }

    public static class withSha512
    extends SignatureSpi {
        public withSha512() {
            super(new SHA512Digest(), NISTObjectIdentifiers.id_sha512_256, new SPHINCS256Signer(new SHA512tDigest(256), new SHA512Digest()));
        }
    }
}

