/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.DTLSReliableHandshake;
import com.apusic.org.bouncycastle.tls.DTLSRequest;
import com.apusic.org.bouncycastle.tls.DatagramSender;
import com.apusic.org.bouncycastle.tls.crypto.TlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.TlsHMAC;
import com.apusic.org.bouncycastle.tls.crypto.TlsMAC;
import com.apusic.org.bouncycastle.tls.crypto.TlsMACOutputStream;
import com.apusic.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class DTLSVerifier {
    private final TlsMAC cookieMAC;
    private final TlsMACOutputStream cookieMACOutputStream;

    private static TlsMAC createCookieMAC(TlsCrypto crypto) {
        TlsHMAC mac = crypto.createHMAC(3);
        byte[] secret = new byte[mac.getMacLength()];
        crypto.getSecureRandom().nextBytes(secret);
        mac.setKey(secret, 0, secret.length);
        return mac;
    }

    public DTLSVerifier(TlsCrypto crypto) {
        this.cookieMAC = DTLSVerifier.createCookieMAC(crypto);
        this.cookieMACOutputStream = new TlsMACOutputStream(this.cookieMAC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DTLSRequest verifyRequest(byte[] clientID, byte[] data, int dataOff, int dataLen, DatagramSender sender) {
        boolean resetCookieMAC = true;
        try {
            this.cookieMAC.update(clientID, 0, clientID.length);
            DTLSRequest request = DTLSReliableHandshake.readClientRequest(data, dataOff, dataLen, this.cookieMACOutputStream);
            if (null != request) {
                byte[] expectedCookie = this.cookieMAC.calculateMAC();
                resetCookieMAC = false;
                if (Arrays.constantTimeAreEqual(expectedCookie, request.getClientHello().getCookie())) {
                    DTLSRequest dTLSRequest = request;
                    return dTLSRequest;
                }
                DTLSReliableHandshake.sendHelloVerifyRequest(sender, request.getRecordSeq(), expectedCookie);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (resetCookieMAC) {
                this.cookieMAC.reset();
            }
        }
        return null;
    }
}

