/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.apusic.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.apusic.org.bouncycastle.tls.Certificate;
import com.apusic.org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.crypto.TlsCertificate;
import com.apusic.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.apusic.org.bouncycastle.tls.crypto.TlsSigner;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2Signer;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.apusic.org.bouncycastle.util.encoders.Hex;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;

public class GMTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static final byte[] userID = Hex.decodeStrict("31323334353637383132333435363738");

    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        BcTlsCrypto bcCrypto = new BcTlsCrypto(crypto.getSecureRandom());
        ECPrivateKeyParameters asymmetricKeyParameter = null;
        try {
            asymmetricKeyParameter = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(privateKey);
            return new BcTlsSM2Signer(bcCrypto, asymmetricKeyParameter, userID);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GMTlsCredentialedSigner(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey signPriKey, PrivateKey encPriKey, Certificate signCert, Certificate encCert, SignatureAndHashAlgorithm sigAndHashAlg) {
        super(cryptoParams, GMTlsCredentialedSigner.makeSigner(crypto, signPriKey), GMTlsCredentialedSigner.combineCerts(signCert, encCert), sigAndHashAlg);
        cryptoParams.getSecurityParametersHandshake().privateKey = encPriKey;
    }

    private static Certificate combineCerts(Certificate signCert, Certificate encCert) {
        TlsCertificate[] signArray = signCert.getCertificateList();
        TlsCertificate encCertHead = encCert.getCertificateAt(0);
        ArrayList<TlsCertificate> tlsCertificateList = new ArrayList<TlsCertificate>();
        tlsCertificateList.addAll(Arrays.asList(signArray));
        tlsCertificateList.add(1, encCertHead);
        return new Certificate(tlsCertificateList.toArray(new TlsCertificate[0]));
    }
}

