/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.asn1.ASN1Integer;
import com.apusic.org.bouncycastle.asn1.DEROctetString;
import com.apusic.org.bouncycastle.asn1.DLSequence;
import com.apusic.org.bouncycastle.jcajce.provider.asymmetric.ec.GMCipherSpi;
import com.apusic.org.bouncycastle.tls.Certificate;
import com.apusic.org.bouncycastle.tls.DigestInputBuffer;
import com.apusic.org.bouncycastle.tls.TlsCredentialedSigner;
import com.apusic.org.bouncycastle.tls.TlsCredentials;
import com.apusic.org.bouncycastle.tls.TlsECDHKeyExchange;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.TlsCertificate;
import com.apusic.org.bouncycastle.tls.crypto.TlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.TlsSecret;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;

public class GMTlsECDHKeyExchange
extends TlsECDHKeyExchange {
    protected TlsCredentialedSigner serverCredentials = null;
    private byte[] preMasterSecret;

    public GMTlsECDHKeyExchange(int keyExchange) {
        super(keyExchange);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireSignerCredentials(serverCredentials);
    }

    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        Certificate certificate = this.serverCredentials.getCertificate();
        TlsCertificate encCert = certificate.getCertificateAt(1);
        byte[] encoded = encCert.getEncoded();
        int messageLength = encoded.length;
        digestBuffer.write((byte)(messageLength >> 16));
        digestBuffer.write((byte)(messageLength >> 8));
        digestBuffer.write((byte)messageLength);
        digestBuffer.write(encoded);
        TlsUtils.generateGMTlsServerKeyExchangeSignature(this.context, this.serverCredentials, digestBuffer);
        return digestBuffer.toByteArray();
    }

    public void skipClientCredentials() throws IOException {
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] raw = TlsUtils.readOpaque16(input);
        DLSequence sequence = (DLSequence)TlsUtils.readDERObject(raw);
        if (sequence.size() < 4) {
            throw new IllegalArgumentException();
        }
        BigInteger px = ((ASN1Integer)sequence.getObjectAt(0)).getValue();
        BigInteger py = ((ASN1Integer)sequence.getObjectAt(1)).getValue();
        byte[] hash = ((DEROctetString)sequence.getObjectAt(2)).getOctets();
        byte[] ciphertxt = ((DEROctetString)sequence.getObjectAt(3)).getOctets();
        byte[] temp = new byte[raw.length];
        int pos = 0;
        temp[0] = 4;
        ++pos;
        byte[] pxb = px.toByteArray();
        if (pxb[0] == 0) {
            System.arraycopy(pxb, 1, temp, pos, pxb.length - 1);
            pos += pxb.length - 1;
        } else {
            System.arraycopy(pxb, 0, temp, pos, pxb.length);
            pos += pxb.length;
        }
        byte[] pyb = py.toByteArray();
        if (pyb[0] == 0) {
            System.arraycopy(pyb, 1, temp, pos, pyb.length - 1);
            pos += pyb.length - 1;
        } else {
            System.arraycopy(pyb, 0, temp, pos, pyb.length);
            pos += pyb.length;
        }
        System.arraycopy(ciphertxt, 0, temp, pos, ciphertxt.length);
        System.arraycopy(hash, 0, temp, pos += ciphertxt.length, hash.length);
        byte[] encodedPremasterSecret = new byte[pos += hash.length];
        System.arraycopy(temp, 0, encodedPremasterSecret, 0, pos);
        this.preMasterSecret = this.decrypted(encodedPremasterSecret, this.context.getSecurityParametersHandshake().privateKey);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsCrypto crypto = this.context.getCrypto();
        if (crypto instanceof JcaTlsCrypto) {
            return new JceTlsSecret((JcaTlsCrypto)crypto, this.preMasterSecret);
        }
        return new BcTlsSecret((BcTlsCrypto)crypto, this.preMasterSecret);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{64};
    }

    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        int certsLength = clientCertificate.getLength();
        if (certsLength < 2) {
            throw new IOException("need sign and encrypt cert chain");
        }
        TlsCertificate signCerts = clientCertificate.getCertificateAt(0);
        TlsCertificate crypCerts = clientCertificate.getCertificateAt(1);
        this.ecdhPeerCertificate = signCerts.checkUsageInRole(1, 5);
    }

    public boolean requiresCertificateVerify() {
        return this.ecdhPeerCertificate != null;
    }

    private byte[] decrypted(byte[] encodedPremasterSecret, PrivateKey privateKey) {
        try {
            GMCipherSpi.SM2 sm2 = new GMCipherSpi.SM2();
            sm2.engineInit(2, privateKey, null);
            byte[] decrypted = sm2.engineDoFinal(encodedPremasterSecret, 0, encodedPremasterSecret.length);
            if (decrypted.length != 48) {
                // empty if block
            }
            return decrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

