/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.TlsProtocol;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class HandshakeMessageOutput
extends ByteArrayOutputStream {
    static int getLength(int bodyLength) {
        return 4 + bodyLength;
    }

    static void send(TlsProtocol protocol, short handshakeType, byte[] body) throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(handshakeType, body.length);
        message.write(body);
        message.send(protocol);
    }

    HandshakeMessageOutput(short handshakeType) throws IOException {
        this(handshakeType, 60);
    }

    HandshakeMessageOutput(short handshakeType, int bodyLength) throws IOException {
        super(HandshakeMessageOutput.getLength(bodyLength));
        TlsUtils.checkUint8(handshakeType);
        TlsUtils.writeUint8(handshakeType, (OutputStream)this);
        this.count += 3;
    }

    void send(TlsProtocol protocol) throws IOException {
        int bodyLength = this.count - 4;
        TlsUtils.checkUint24(bodyLength);
        TlsUtils.writeUint24(bodyLength, this.buf, 1);
        protocol.writeHandshakeMessage(this.buf, 0, this.count);
        this.buf = null;
    }
}

