/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.TlsSRPIdentityManager;
import com.apusic.org.bouncycastle.tls.TlsSRPLoginParameters;
import com.apusic.org.bouncycastle.tls.crypto.SRP6Group;
import com.apusic.org.bouncycastle.tls.crypto.TlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.TlsHMAC;
import com.apusic.org.bouncycastle.tls.crypto.TlsMAC;
import com.apusic.org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import com.apusic.org.bouncycastle.tls.crypto.TlsSRPConfig;
import com.apusic.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] PREFIX_PASSWORD = Strings.toByteArray("password");
    private static final byte[] PREFIX_SALT = Strings.toByteArray("salt");
    protected SRP6Group group;
    protected TlsSRP6VerifierGenerator verifierGenerator;
    protected TlsMAC mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(TlsCrypto crypto, SRP6Group group, byte[] seedKey) throws IOException {
        TlsHMAC mac = crypto.createHMAC(2);
        mac.setKey(seedKey, 0, seedKey.length);
        TlsSRPConfig srpConfig = new TlsSRPConfig();
        srpConfig.setExplicitNG(new BigInteger[]{group.getN(), group.getG()});
        return new SimulatedTlsSRPIdentityManager(group, crypto.createSRP6VerifierGenerator(srpConfig), mac);
    }

    public SimulatedTlsSRPIdentityManager(SRP6Group group, TlsSRP6VerifierGenerator verifierGenerator, TlsMAC mac) {
        this.group = group;
        this.verifierGenerator = verifierGenerator;
        this.mac = mac;
    }

    public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
        this.mac.update(PREFIX_SALT, 0, PREFIX_SALT.length);
        this.mac.update(identity, 0, identity.length);
        byte[] salt = this.mac.calculateMAC();
        this.mac.update(PREFIX_PASSWORD, 0, PREFIX_PASSWORD.length);
        this.mac.update(identity, 0, identity.length);
        byte[] password = this.mac.calculateMAC();
        BigInteger verifier = this.verifierGenerator.generateVerifier(salt, identity, password);
        TlsSRPConfig srpConfig = new TlsSRPConfig();
        srpConfig.setExplicitNG(new BigInteger[]{this.group.getN(), this.group.getG()});
        return new TlsSRPLoginParameters(identity, srpConfig, verifier, salt);
    }
}

