/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.AbstractTlsKeyExchange;
import com.apusic.org.bouncycastle.tls.Certificate;
import com.apusic.org.bouncycastle.tls.DigestInputBuffer;
import com.apusic.org.bouncycastle.tls.TlsCredentialedSigner;
import com.apusic.org.bouncycastle.tls.TlsCredentials;
import com.apusic.org.bouncycastle.tls.TlsDHGroupVerifier;
import com.apusic.org.bouncycastle.tls.TlsDHUtils;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.TlsAgreement;
import com.apusic.org.bouncycastle.tls.crypto.TlsCertificate;
import com.apusic.org.bouncycastle.tls.crypto.TlsDHConfig;
import com.apusic.org.bouncycastle.tls.crypto.TlsSecret;
import com.apusic.org.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsDHEKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsCertificate serverCertificate = null;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 3: 
            case 5: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) {
        this(keyExchange, dhGroupVerifier, null);
    }

    public TlsDHEKeyExchange(int keyExchange, TlsDHConfig dhConfig) {
        this(keyExchange, null, dhConfig);
    }

    private TlsDHEKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier, TlsDHConfig dhConfig) {
        super(TlsDHEKeyExchange.checkKeyExchange(keyExchange));
        this.dhGroupVerifier = dhGroupVerifier;
        this.dhConfig = dhConfig;
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireSignerCredentials(serverCredentials);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TlsDHUtils.writeDHConfig(this.dhConfig, digestBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, digestBuffer);
        TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, digestBuffer);
        return digestBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, digestBuffer);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, teeIn);
        byte[] y = TlsUtils.readOpaque16(teeIn, 1);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, input, this.serverCertificate, digestBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(y);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, output);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        this.agreement.receivePeerValue(TlsUtils.readOpaque16(input, 1));
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

