/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.InvalidCipherTextException;
import com.apusic.org.bouncycastle.crypto.modes.AEADBlockCipher;
import com.apusic.org.bouncycastle.crypto.params.AEADParameters;
import com.apusic.org.bouncycastle.crypto.params.KeyParameter;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import java.io.IOException;

final class BcTlsAEADCipherImpl
implements TlsAEADCipherImpl {
    private final boolean isEncrypting;
    private final AEADBlockCipher cipher;
    private KeyParameter key;

    BcTlsAEADCipherImpl(AEADBlockCipher cipher, boolean isEncrypting) {
        this.cipher = cipher;
        this.isEncrypting = isEncrypting;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new KeyParameter(key, keyOff, keyLen);
    }

    public void init(byte[] nonce, int macSize, byte[] additionalData) {
        this.cipher.init(this.isEncrypting, new AEADParameters(this.key, macSize * 8, nonce, additionalData));
    }

    public int getOutputSize(int inputLength) {
        return this.cipher.getOutputSize(inputLength);
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] extraInput, byte[] output, int outputOffset) throws IOException {
        int len = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
        int extraInputLength = extraInput.length;
        if (extraInputLength > 0) {
            if (!this.isEncrypting) {
                throw new TlsFatalAlert(80);
            }
            len += this.cipher.processBytes(extraInput, 0, extraInputLength, output, outputOffset + len);
        }
        try {
            len += this.cipher.doFinal(output, outputOffset + len);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(20, (Throwable)e);
        }
        return len;
    }
}

