/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.InvalidCipherTextException;
import com.apusic.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.apusic.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.apusic.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import java.io.IOException;

final class BcTlsRSAEncryptor
implements TlsEncryptor {
    private final BcTlsCrypto crypto;
    private final RSAKeyParameters pubKeyRSA;

    private static RSAKeyParameters checkPublicKey(RSAKeyParameters pubKeyRSA) {
        if (null == pubKeyRSA || pubKeyRSA.isPrivate()) {
            throw new IllegalArgumentException("No public RSA key provided");
        }
        return pubKeyRSA;
    }

    BcTlsRSAEncryptor(BcTlsCrypto crypto, RSAKeyParameters pubKeyRSA) {
        this.crypto = crypto;
        this.pubKeyRSA = BcTlsRSAEncryptor.checkPublicKey(pubKeyRSA);
    }

    public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
        try {
            PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
            encoding.init(true, new ParametersWithRandom(this.pubKeyRSA, this.crypto.getSecureRandom()));
            return encoding.processBlock(input, inOff, length);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

