/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithID;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.apusic.org.bouncycastle.crypto.signers.SM2Signer;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;
import com.apusic.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcTlsSM2Signer
extends BcTlsSigner {
    protected final byte[] identifier;

    public BcTlsSM2Signer(BcTlsCrypto crypto, ECPrivateKeyParameters privateKey, byte[] identifier) {
        super(crypto, privateKey);
        this.identifier = Arrays.clone(identifier);
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) {
        if (algorithm == null) {
            // empty if block
        }
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom());
        ParametersWithID parametersWithID = new ParametersWithID(parametersWithRandom, this.identifier);
        SM2Signer signer = new SM2Signer();
        signer.init(true, parametersWithID);
        return new BcTlsStreamSigner(signer);
    }
}

