/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.CryptoException;
import com.apusic.org.bouncycastle.crypto.Signer;
import com.apusic.org.bouncycastle.crypto.io.SignerOutputStream;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.apusic.org.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BcVerifyingStreamSigner
implements TlsStreamSigner {
    private final Signer signer;
    private final Signer verifier;
    private final TeeOutputStream output;

    BcVerifyingStreamSigner(Signer signer, Signer verifier) {
        SignerOutputStream outputSigner = new SignerOutputStream(signer);
        SignerOutputStream outputVerifier = new SignerOutputStream(verifier);
        this.signer = signer;
        this.verifier = verifier;
        this.output = new TeeOutputStream(outputSigner, outputVerifier);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public byte[] getSignature() throws IOException {
        try {
            byte[] signature = this.signer.generateSignature();
            if (this.verifier.verifySignature(signature)) {
                return signature;
            }
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        throw new TlsFatalAlert(80);
    }
}

