/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.tls.DigitallySigned;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSSVerifier;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;

public class JcaGMTlsECDSAVerifier
extends JcaTlsDSSVerifier {
    protected JcaGMTlsECDSAVerifier(JcaTlsCrypto crypto, PublicKey publicKey) {
        super(crypto, publicKey, (short)3, "SM3WITHSM2");
    }

    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.algorithmType) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        try {
            Signature signer = this.crypto.getHelper().createSignature(this.algorithmName);
            signer.initVerify(this.publicKey);
            signer.update(hash, 0, hash.length);
            return signer.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

