/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.tls.DigitallySigned;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.apusic.org.bouncycastle.tls.crypto.TlsVerifier;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;

public abstract class JcaTlsDSSVerifier
implements TlsVerifier {
    protected final JcaTlsCrypto crypto;
    protected final PublicKey publicKey;
    protected final short algorithmType;
    protected final String algorithmName;

    protected JcaTlsDSSVerifier(JcaTlsCrypto crypto, PublicKey publicKey, short algorithmType, String algorithmName) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
        this.algorithmType = algorithmType;
        this.algorithmName = algorithmName;
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) throws IOException {
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.algorithmType) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        try {
            Signature signer = this.crypto.getHelper().createSignature(this.algorithmName);
            signer.initVerify(this.publicKey);
            if (algorithm == null) {
                signer.update(hash, 16, 20);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

