/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.SignatureScheme;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.crypto.TlsSigner;
import com.apusic.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class JcaTlsECDSA13Signer
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final int signatureScheme;

    public JcaTlsECDSA13Signer(JcaTlsCrypto crypto, PrivateKey privateKey, int signatureScheme) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        if (!SignatureScheme.isECDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = crypto;
        this.privateKey = privateKey;
        this.signatureScheme = signatureScheme;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        try {
            Signature signer = this.crypto.getHelper().createSignature("NoneWithECDSA");
            signer.initSign(this.privateKey, this.crypto.getSecureRandom());
            signer.update(hash, 0, hash.length);
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        return null;
    }
}

