/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.srp;

import com.apusic.org.bouncycastle.tls.crypto.SRP6Group;
import com.apusic.org.bouncycastle.tls.crypto.TlsHash;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Util;
import java.math.BigInteger;

public class SRP6VerifierGenerator {
    protected BigInteger N;
    protected BigInteger g;
    protected TlsHash digest;

    public void init(BigInteger N, BigInteger g, TlsHash digest) {
        this.N = N;
        this.g = g;
        this.digest = digest;
    }

    public void init(SRP6Group group, TlsHash digest) {
        this.N = group.getN();
        this.g = group.getG();
        this.digest = digest;
    }

    public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
        BigInteger x = SRP6Util.calculateX(this.digest, this.N, salt, identity, password);
        return this.g.modPow(x, this.N);
    }
}

