/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code.interpreter;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.InterpretExpression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.code.BaseEvalCodeGenerator;
import com.googlecode.aviator.code.LambdaGenerator;
import com.googlecode.aviator.code.asm.ASMCodeGenerator;
import com.googlecode.aviator.code.interpreter.IR;
import com.googlecode.aviator.code.interpreter.ir.AssertTypeIR;
import com.googlecode.aviator.code.interpreter.ir.BranchIfIR;
import com.googlecode.aviator.code.interpreter.ir.BranchUnlessIR;
import com.googlecode.aviator.code.interpreter.ir.ClearIR;
import com.googlecode.aviator.code.interpreter.ir.GotoIR;
import com.googlecode.aviator.code.interpreter.ir.JumpIR;
import com.googlecode.aviator.code.interpreter.ir.Label;
import com.googlecode.aviator.code.interpreter.ir.LoadIR;
import com.googlecode.aviator.code.interpreter.ir.NewLambdaIR;
import com.googlecode.aviator.code.interpreter.ir.OperatorIR;
import com.googlecode.aviator.code.interpreter.ir.PopIR;
import com.googlecode.aviator.code.interpreter.ir.SendIR;
import com.googlecode.aviator.code.interpreter.ir.SourceInfo;
import com.googlecode.aviator.code.interpreter.ir.VisitLabelIR;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.op.OperationRuntime;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.utils.IdentityHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class InterpretCodeGenerator
extends BaseEvalCodeGenerator {
    private final List<IR> instruments = new ArrayList<IR>();
    private Set<Token<?>> constantPool = Collections.emptySet();
    private int labelNum;
    private final Stack<Label> labels0 = new Stack();
    private final Stack<Label> labels1 = new Stack();
    private Label currLabel;
    private static Set<Token.TokenType> LOAD_CONSTANTS_TYPE = new IdentityHashSet<Token.TokenType>();

    private void visitLabel(Label label) {
        this.currLabel = label;
        this.emit(new VisitLabelIR(label));
    }

    private void pushLabel0(Label label) {
        this.labels0.push(label);
    }

    private Label popLabel0() {
        return this.labels0.pop();
    }

    private Label peekLabel0() {
        return this.labels0.peek();
    }

    private void pushLabel1(Label label) {
        this.labels1.push(label);
    }

    private Label popLabel1() {
        return this.labels1.pop();
    }

    private Label peekLabel1() {
        return this.labels1.peek();
    }

    private Label makeLabel() {
        return new Label(this.labelNum++);
    }

    @Override
    public void start() {
    }

    @Override
    public void initVariables(Map<String, VariableMeta> vars) {
        this.variables = vars;
    }

    @Override
    public void initConstants(Set<Token<?>> constants) {
        if (constants.isEmpty()) {
            return;
        }
        this.constantPool = constants;
    }

    @Override
    public void initMethods(Map<String, Integer> methods) {
    }

    @Override
    public void genNewLambdaCode(LambdaFunctionBootstrap bootstrap) {
        this.emit(new NewLambdaIR(bootstrap.getName()));
    }

    public InterpretCodeGenerator(AviatorEvaluatorInstance instance, String sourceFile, AviatorClassLoader classLoader) {
        super(instance, sourceFile, classLoader);
        LOAD_CONSTANTS_TYPE.add(Token.TokenType.Number);
        LOAD_CONSTANTS_TYPE.add(Token.TokenType.String);
        LOAD_CONSTANTS_TYPE.add(Token.TokenType.Pattern);
        LOAD_CONSTANTS_TYPE.add(Token.TokenType.Variable);
    }

    @Override
    public void onAssignment(Token<?> lookhead) {
        if (lookhead.getMeta("define", false).booleanValue()) {
            this.emit(OperatorIR.DEF);
        } else {
            this.emit(OperatorIR.ASSIGN);
        }
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.emit(OperatorIR.SHIFT_RIGHT);
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.emit(OperatorIR.SHIFT_LEFT);
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.emit(OperatorIR.UNSIGNED_SHIFT_RIGHT);
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.emit(OperatorIR.BIT_OR);
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.emit(OperatorIR.BIT_AND);
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.emit(OperatorIR.BIT_XOR);
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.emit(OperatorIR.BIT_NOT);
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.emit(OperatorIR.ADD);
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.emit(OperatorIR.SUB);
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.emit(OperatorIR.MULT);
    }

    @Override
    public void onExponent(Token<?> loohead) {
        this.emit(OperatorIR.EXP);
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.emit(OperatorIR.DIV);
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        if (!OperationRuntime.containsOpFunction(this.compileEnv, OperatorType.AND)) {
            this.emit(new AssertTypeIR(AssertTypeIR.AssertTypes.Bool));
            Label label = this.makeLabel();
            this.pushLabel0(label);
            this.instruments.add(new BranchUnlessIR(label, new SourceInfo(this.sourceFile, lookhead.getLineNo())));
            this.emit(PopIR.INSTANCE);
        }
    }

    private void emit(IR ir) {
        OperatorType op;
        AviatorFunction fn;
        if (ir instanceof OperatorIR && (fn = this.instance.getOpFunction(op = ((OperatorIR)ir).getOp())) != null) {
            ir = new OperatorIR(op, fn);
        }
        this.instruments.add(ir);
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        if (!OperationRuntime.containsOpFunction(this.compileEnv, OperatorType.AND)) {
            this.emit(new AssertTypeIR(AssertTypeIR.AssertTypes.Bool));
            Label label = this.popLabel0();
            this.visitLabel(label);
        } else {
            this.emit(OperatorIR.AND);
        }
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        Label label0 = this.makeLabel();
        this.pushLabel0(label0);
        Label label1 = this.makeLabel();
        this.pushLabel1(label1);
        this.instruments.add(new BranchUnlessIR(label0, new SourceInfo(this.sourceFile, lookhead.getLineNo())));
        this.emit(PopIR.INSTANCE);
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.instruments.add(new GotoIR(this.peekLabel1(), new SourceInfo(this.sourceFile, lookhead.getLineNo())));
        Label label0 = this.popLabel0();
        this.visitLabel(label0);
        this.emit(PopIR.INSTANCE);
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        Label label1 = this.popLabel1();
        this.visitLabel(label1);
    }

    @Override
    public void onTernaryEnd(Token<?> lookhead) {
        this.emit(ClearIR.INSTANCE);
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        if (!OperationRuntime.containsOpFunction(this.compileEnv, OperatorType.AND)) {
            this.emit(new AssertTypeIR(AssertTypeIR.AssertTypes.Bool));
            Label label = this.makeLabel();
            this.pushLabel0(label);
            this.instruments.add(new BranchIfIR(label, new SourceInfo(this.sourceFile, lookhead.getLineNo())));
            this.emit(PopIR.INSTANCE);
        }
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        if (!OperationRuntime.containsOpFunction(this.compileEnv, OperatorType.AND)) {
            this.emit(new AssertTypeIR(AssertTypeIR.AssertTypes.Bool));
            Label label = this.popLabel0();
            this.visitLabel(label);
        } else {
            this.emit(OperatorIR.OR);
        }
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.emit(OperatorIR.EQ);
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.emit(OperatorIR.MATCH);
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.emit(OperatorIR.NE);
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.emit(OperatorIR.LT);
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.emit(OperatorIR.LE);
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.emit(OperatorIR.GT);
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.emit(OperatorIR.GE);
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.emit(OperatorIR.MOD);
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.emit(OperatorIR.NOT);
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.emit(OperatorIR.NEG);
    }

    @Override
    public Expression getResult(boolean unboxObject) {
        List<IR> instruments = this.instruments;
        this.optimize(instruments);
        this.resolveLabels(instruments);
        InterpretExpression exp = new InterpretExpression(this.instance, new ArrayList<VariableMeta>(this.variables.values()), this.constantPool, this.symbolTable, instruments, unboxObject);
        exp.setLambdaBootstraps(this.lambdaBootstraps);
        exp.setSourceFile(this.sourceFile);
        exp.setFuncsArgs(this.funcsArgs);
        return exp;
    }

    private void optimize(List<IR> instruments) {
    }

    private void resolveLabels(List<IR> instruments) {
        IdentityHashMap<Label, Integer> label2pc = new IdentityHashMap<Label, Integer>();
        ListIterator<IR> it = instruments.listIterator();
        int i = 0;
        while (it.hasNext()) {
            IR ir = it.next();
            if (ir instanceof VisitLabelIR) {
                it.remove();
                label2pc.put(((VisitLabelIR)ir).getLabel(), i);
                continue;
            }
            ++i;
        }
        for (IR ir : instruments) {
            if (!(ir instanceof JumpIR)) continue;
            ((JumpIR)((Object)ir)).setPc((Integer)label2pc.get(((JumpIR)((Object)ir)).getLabel()));
        }
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        if (LOAD_CONSTANTS_TYPE.contains((Object)lookhead.getType())) {
            VariableMeta meta = null;
            if (lookhead.getType() == Token.TokenType.Variable) {
                meta = (VariableMeta)this.variables.get(lookhead.getLexeme());
            }
            this.emit(new LoadIR(this.sourceFile, lookhead, meta, this.constantPool.contains(lookhead)));
        }
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        ASMCodeGenerator.MethodMetaData metadata = new ASMCodeGenerator.MethodMetaData(lookhead, lookhead.getType() == Token.TokenType.Delegate ? null : lookhead.getLexeme());
        this.methodMetaDataStack.push(metadata);
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        ASMCodeGenerator.MethodMetaData currentMethodMetaData = (ASMCodeGenerator.MethodMetaData)this.methodMetaDataStack.peek();
        ++currentMethodMetaData.parameterCount;
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        List params;
        ASMCodeGenerator.MethodMetaData methodMetaData = (ASMCodeGenerator.MethodMetaData)this.methodMetaDataStack.pop();
        List list = params = lookhead != null ? lookhead.getMeta("params", Collections.EMPTY_LIST) : Collections.emptyList();
        if (this.instance.getOptionValue((Options)Options.CAPTURE_FUNCTION_ARGS).bool) {
            int funcId = this.getNextFuncInvocationId();
            this.getFuncsArgs().put(funcId, Collections.unmodifiableList(params));
            methodMetaData.funcId = funcId;
        }
        this.emit(new SendIR(methodMetaData.methodName, methodMetaData.parameterCount, methodMetaData.token.getMeta("unpackingArgs", false), methodMetaData.funcId, new SourceInfo(this.sourceFile, methodMetaData.token.getLineNo())));
    }

    @Override
    public void onLambdaDefineStart(Token<?> lookhead) {
        if (this.lambdaGenerator != null) {
            throw new CompileExpressionErrorException("Compile lambda error");
        }
        Boolean newLexicalScope = lookhead.getMeta("newLexicalScope", false);
        Boolean inheritEnv = lookhead.getMeta("inheritEnv", false);
        this.lambdaGenerator = new LambdaGenerator(this.instance, this, this.parser, this.classLoader, this.sourceFile, newLexicalScope, inheritEnv);
        this.lambdaGenerator.setScopeInfo(this.parser.enterScope(newLexicalScope));
    }

    @Override
    public void onLambdaArgument(Token<?> lookhead, FunctionParam param) {
        this.lambdaGenerator.addParam(param);
    }

    @Override
    public void onLambdaBodyStart(Token<?> lookhead) {
        this.parentCodeGenerator = this.parser.getCodeGenerator();
        this.parser.setCodeGenerator(this.lambdaGenerator);
    }

    @Override
    public void onLambdaBodyEnd(Token<?> lookhead) {
        LambdaFunctionBootstrap bootstrap = this.lambdaGenerator.getLmabdaBootstrap();
        if (this.lambdaBootstraps == null) {
            this.lambdaBootstraps = new LinkedHashMap();
        }
        this.lambdaBootstraps.put(bootstrap.getName(), bootstrap);
        this.genNewLambdaCode(bootstrap);
        this.parser.restoreScope(this.lambdaGenerator.getScopeInfo());
        this.lambdaGenerator = null;
        this.parser.setCodeGenerator(this.parentCodeGenerator);
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.onConstant(lookhead);
    }

    @Override
    public void onArrayIndexStart(Token<?> token) {
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        this.emit(OperatorIR.INDEX);
    }
}

