/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

public abstract class LuminanceSource {
    private final int width;
    private final int height;

    protected LuminanceSource(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public abstract byte[] getRow(int var1, byte[] var2);

    public abstract byte[] getMatrix();

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean isCropSupported() {
        return false;
    }

    public LuminanceSource crop(int left, int top, int width, int height) {
        throw new UnsupportedOperationException("This luminance source does not support cropping.");
    }

    public boolean isRotateSupported() {
        return false;
    }

    public LuminanceSource rotateCounterClockwise() {
        throw new UnsupportedOperationException("This luminance source does not support rotation.");
    }

    public String toString() {
        byte[] row = new byte[this.width];
        StringBuilder result = new StringBuilder(this.height * (this.width + 1));
        int y = 0;
        while (y < this.height) {
            row = this.getRow(y, row);
            int x = 0;
            while (x < this.width) {
                int luminance = row[x] & 0xFF;
                int c = luminance < 64 ? 35 : (luminance < 128 ? 43 : (luminance < 192 ? 46 : 32));
                result.append((char)c);
                ++x;
            }
            result.append('\n');
            ++y;
        }
        return result.toString();
    }
}

