/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.AlgoException;

public class CacheHint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DEFAULT_TIMEOUT = "algo.cacheDataSet.defaultTimeout";
    public static int DefaultTimeout = 3600000;
    private long timeout = -1L;
    private int pageSize = 1024;
    private String cacheId;
    private String storageType;

    public static CacheHint getDefault() {
        return new CacheHint();
    }

    public long getTimeout() {
        if (this.timeout <= 0L) {
            return this.getConfigTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private long getConfigTimeout() {
        String s = System.getProperty(KEY_DEFAULT_TIMEOUT);
        if (s != null) {
            try {
                long timeout = Long.parseLong(s);
                return timeout;
            }
            catch (Throwable t) {
                throw new AlgoException("parse algo.cacheDataSet.defaultTimeout error,should be Integer, but find " + s, t);
            }
        }
        return DefaultTimeout;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }
}

